%------------------------------------------------------------------------------
% File     : ITP055^2 : TPTP v9.2.0. Released v7.5.0.
% Domain   : Interactive Theorem Proving
% Problem  : Sledgehammer FLPTheorem problem prob_1231__3305662_1
% Version  : Especial.
% English  :

% Refs     : [BH+15] Blanchette et al. (2015), Mining the Archive of Formal
%          : [Des21] Desharnais (2021), Email to Geoff Sutcliffe
% Source   : [Des21]
% Names    : FLPTheorem/prob_1231__3305662_1 [Des21]

% Status   : Theorem
% Rating   : 0.00 v7.5.0
% Syntax   : Number of formulae    :  356 ( 128 unt;  62 typ;   0 def)
%            Number of atoms       :  674 ( 300 equ;   0 cnn)
%            Maximal formula atoms :    6 (   2 avg)
%            Number of connectives : 4532 ( 120   ~;   7   |;  28   &;4008   @)
%                                         (   0 <=>; 369  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   28 (   7 avg)
%            Number of types       :    7 (   6 usr)
%            Number of type conns  :  445 ( 445   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   57 (  56 usr;   4 con; 0-8 aty)
%            Number of variables   :  937 (   8   ^; 845   !;  31   ?; 937   :)
%                                         (  53  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Sledgehammer 2021-02-23 16:17:36.018
%------------------------------------------------------------------------------
% Could-be-implicit typings (11)
thf(ty_t_AsynchronousSystem_Oconfiguration_Oconfiguration__ext,type,
    configuration_ext: $tType > $tType > $tType > $tType > $tType ).

thf(ty_t_AsynchronousSystem_OmessageValue,type,
    messageValue: $tType > $tType ).

thf(ty_t_AsynchronousSystem_Omessage,type,
    message: $tType > $tType > $tType ).

thf(ty_t_Product__Type_Ounit,type,
    product_unit: $tType ).

thf(ty_t_List_Olist,type,
    list: $tType > $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_t_Nat_Onat,type,
    nat: $tType ).

thf(ty_t_Int_Oint,type,
    int: $tType ).

thf(ty_tf_v,type,
    v: $tType ).

thf(ty_tf_s,type,
    s: $tType ).

thf(ty_tf_p,type,
    p: $tType ).

% Explicit typings (51)
thf(sy_cl_HOL_Otype,type,
    type: 
      !>[A: $tType] : $o ).

thf(sy_cl_Nat_Osize,type,
    size: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Oring__1,type,
    ring_1: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

thf(sy_cl_Nat_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

thf(sy_cl_Nat_Osemiring__char__0,type,
    semiring_char_0: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Owellorder,type,
    wellorder: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

thf(sy_cl_Lattices_Oboolean__algebra,type,
    boolean_algebra: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Oordered__ab__group__add,type,
    ordered_ab_group_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Olinordered__nonzero__semiring,type,
    linord1659791738miring: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ocanonically__ordered__monoid__add,type,
    canoni770627133id_add: 
      !>[A: $tType] : $o ).

thf(sy_c_BNF__Greatest__Fixpoint_Oshift,type,
    bNF_Greatest_shift: 
      !>[A: $tType,B: $tType] : ( ( ( list @ A ) > B ) > A > ( list @ A ) > B ) ).

thf(sy_c_FLPTheorem__Mirabelle__yavhmxymmt_OflpPseudoConsensus,type,
    fLPThe1922692578sensus: 
      !>[P: $tType,S: $tType,V: $tType] : ( ( P > S > ( messageValue @ V ) > S ) > ( P > S > ( messageValue @ V ) > ( message @ P @ V ) > nat ) > ( P > S ) > $o ) ).

thf(sy_c_FLPTheorem__Mirabelle__yavhmxymmt_OflpPseudoConsensus_OinfiniteExecutionCfg,type,
    fLPThe137922386ionCfg: 
      !>[P: $tType,V: $tType,S: $tType] : ( ( configuration_ext @ P @ V @ S @ product_unit ) > ( ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) ) > ( ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( message @ P @ V ) ) ) > nat > ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) ) ).

thf(sy_c_FLPTheorem__Mirabelle__yavhmxymmt_OflpPseudoConsensus_OinfiniteExecutionMsg,type,
    fLPThe221390223ionMsg: 
      !>[P: $tType,V: $tType,S: $tType] : ( ( configuration_ext @ P @ V @ S @ product_unit ) > ( ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) ) > ( ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( message @ P @ V ) ) ) > nat > ( list @ ( message @ P @ V ) ) ) ).

thf(sy_c_FLPTheorem__Mirabelle__yavhmxymmt_OflpSystem_OterminationFLP,type,
    fLPThe2031355932ionFLP: 
      !>[P: $tType,S: $tType,V: $tType] : ( ( P > S > ( messageValue @ V ) > S ) > ( P > S > ( messageValue @ V ) > ( message @ P @ V ) > nat ) > ( P > S ) > ( nat > ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) ) > ( nat > ( list @ ( message @ P @ V ) ) ) > $o ) ).

thf(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

thf(sy_c_Groups_Ouminus__class_Ouminus,type,
    uminus_uminus: 
      !>[A: $tType] : ( A > A ) ).

thf(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

thf(sy_c_Int_Onat,type,
    nat2: int > nat ).

thf(sy_c_Int_Oring__1__class_Oof__int,type,
    ring_1_of_int: 
      !>[A: $tType] : ( int > A ) ).

thf(sy_c_ListUtilities_OprefixList,type,
    prefixList: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) > $o ) ).

thf(sy_c_List_Ogen__length,type,
    gen_length: 
      !>[A: $tType] : ( nat > ( list @ A ) > nat ) ).

thf(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( A > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( A > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : ( list @ A ) ).

thf(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( A > $o ) > ( list @ A ) > $o ) ).

thf(sy_c_List_On__lists,type,
    n_lists: 
      !>[A: $tType] : ( nat > ( list @ A ) > ( list @ ( list @ A ) ) ) ).

thf(sy_c_List_Onths,type,
    nths: 
      !>[A: $tType] : ( ( list @ A ) > ( set @ nat ) > ( list @ A ) ) ).

thf(sy_c_List_Oproduct__lists,type,
    product_lists: 
      !>[A: $tType] : ( ( list @ ( list @ A ) ) > ( list @ ( list @ A ) ) ) ).

thf(sy_c_List_Osubseqs,type,
    subseqs: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ ( list @ A ) ) ) ).

thf(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

thf(sy_c_Nat_Osemiring__1__class_Oof__nat,type,
    semiring_1_of_nat: 
      !>[A: $tType] : ( nat > A ) ).

thf(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

thf(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_member,type,
    member: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_cfg____,type,
    cfg: configuration_ext @ p @ v @ s @ product_unit ).

thf(sy_v_fe____,type,
    fe: nat > ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) ).

thf(sy_v_m____,type,
    m: nat ).

thf(sy_v_n____,type,
    n: nat ).

thf(sy_v_na____,type,
    na: nat ).

% Relevant facts (251)
thf(fact_0__092_060open_062m_A_060_An_092_060close_062,axiom,
    ord_less @ nat @ m @ na ).

% \<open>m < n\<close>
thf(fact_1_MLessN,axiom,
    ord_less @ nat @ m @ n ).

% MLessN
thf(fact_2_IA_I1_J,axiom,
    ( ( ord_less @ nat @ m @ na )
   => ( prefixList @ ( configuration_ext @ p @ v @ s @ product_unit ) @ ( fe @ m ) @ ( fe @ na ) ) ) ).

% IA(1)
thf(fact_3__092_060open_062m_A_061_An_A_092_060or_062_Am_A_060_An_092_060close_062,axiom,
    ( ( m = na )
    | ( ord_less @ nat @ m @ na ) ) ).

% \<open>m = n \<or> m < n\<close>
thf(fact_4_IA_I2_J,axiom,
    ord_less @ nat @ m @ ( suc @ na ) ).

% IA(2)
thf(fact_5_PrefixListTransitive,axiom,
    ! [A: $tType,L1: list @ A,L2: list @ A,L3: list @ A] :
      ( ( prefixList @ A @ L1 @ L2 )
     => ( ( prefixList @ A @ L2 @ L3 )
       => ( prefixList @ A @ L1 @ L3 ) ) ) ).

% PrefixListTransitive
thf(fact_6_flpSystem_OterminationFLP_Ocong,axiom,
    ! [V: $tType,S: $tType,P: $tType] :
      ( ( fLPThe2031355932ionFLP @ P @ S @ V )
      = ( fLPThe2031355932ionFLP @ P @ S @ V ) ) ).

% flpSystem.terminationFLP.cong
thf(fact_7_FE_I1_J,axiom,
    ( ( fe @ ( zero_zero @ nat ) )
    = ( cons @ ( configuration_ext @ p @ v @ s @ product_unit ) @ cfg @ ( nil @ ( configuration_ext @ p @ v @ s @ product_unit ) ) ) ) ).

% FE(1)
thf(fact_8_prefixList_Ointros_I2_J,axiom,
    ! [A: $tType,Xa: list @ A,Xb: list @ A,X: A] :
      ( ( prefixList @ A @ Xa @ Xb )
     => ( prefixList @ A @ ( cons @ A @ X @ Xa ) @ ( cons @ A @ X @ Xb ) ) ) ).

% prefixList.intros(2)
thf(fact_9_PrefixListMonotonicity,axiom,
    ! [A: $tType,L1: list @ A,L2: list @ A] :
      ( ( prefixList @ A @ L1 @ L2 )
     => ( ord_less @ nat @ ( size_size @ ( list @ A ) @ L1 ) @ ( size_size @ ( list @ A ) @ L2 ) ) ) ).

% PrefixListMonotonicity
thf(fact_10_infiniteExecutionCfg__infiniteExecutionMsg_Oinduct_I2_J,axiom,
    ! [P2: ( configuration_ext @ p @ v @ s @ product_unit ) > ( ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) ) > ( ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( message @ p @ v ) ) ) > nat > $o,Q: ( configuration_ext @ p @ v @ s @ product_unit ) > ( ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) ) > ( ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( message @ p @ v ) ) ) > nat > $o,A4: configuration_ext @ p @ v @ s @ product_unit,A5: ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ),A6: ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( message @ p @ v ) ),A7: nat] :
      ( ! [Cfg: configuration_ext @ p @ v @ s @ product_unit,FStepCfg: ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ),FStepMsg: ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( message @ p @ v ) )] : ( P2 @ Cfg @ FStepCfg @ FStepMsg @ ( zero_zero @ nat ) )
     => ( ! [Cfg: configuration_ext @ p @ v @ s @ product_unit,FStepCfg: ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ),FStepMsg: ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( message @ p @ v ) ),N: nat] :
            ( ( P2 @ Cfg @ FStepCfg @ FStepMsg @ N )
           => ( ( Q @ Cfg @ FStepCfg @ FStepMsg @ N )
             => ( P2 @ Cfg @ FStepCfg @ FStepMsg @ ( suc @ N ) ) ) )
       => ( ! [Cfg: configuration_ext @ p @ v @ s @ product_unit,FStepCfg: ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ),FStepMsg: ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( message @ p @ v ) )] : ( Q @ Cfg @ FStepCfg @ FStepMsg @ ( zero_zero @ nat ) )
         => ( ! [Cfg: configuration_ext @ p @ v @ s @ product_unit,FStepCfg: ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ),FStepMsg: ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( message @ p @ v ) ),N: nat] :
                ( ( P2 @ Cfg @ FStepCfg @ FStepMsg @ N )
               => ( ( Q @ Cfg @ FStepCfg @ FStepMsg @ N )
                 => ( Q @ Cfg @ FStepCfg @ FStepMsg @ ( suc @ N ) ) ) )
           => ( Q @ A4 @ A5 @ A6 @ A7 ) ) ) ) ) ).

% infiniteExecutionCfg_infiniteExecutionMsg.induct(2)
thf(fact_11_infiniteExecutionCfg__infiniteExecutionMsg_Oinduct_I1_J,axiom,
    ! [P2: ( configuration_ext @ p @ v @ s @ product_unit ) > ( ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) ) > ( ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( message @ p @ v ) ) ) > nat > $o,Q: ( configuration_ext @ p @ v @ s @ product_unit ) > ( ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) ) > ( ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( message @ p @ v ) ) ) > nat > $o,A0: configuration_ext @ p @ v @ s @ product_unit,A1: ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ),A2: ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( message @ p @ v ) ),A3: nat] :
      ( ! [Cfg: configuration_ext @ p @ v @ s @ product_unit,FStepCfg: ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ),FStepMsg: ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( message @ p @ v ) )] : ( P2 @ Cfg @ FStepCfg @ FStepMsg @ ( zero_zero @ nat ) )
     => ( ! [Cfg: configuration_ext @ p @ v @ s @ product_unit,FStepCfg: ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ),FStepMsg: ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( message @ p @ v ) ),N: nat] :
            ( ( P2 @ Cfg @ FStepCfg @ FStepMsg @ N )
           => ( ( Q @ Cfg @ FStepCfg @ FStepMsg @ N )
             => ( P2 @ Cfg @ FStepCfg @ FStepMsg @ ( suc @ N ) ) ) )
       => ( ! [Cfg: configuration_ext @ p @ v @ s @ product_unit,FStepCfg: ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ),FStepMsg: ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( message @ p @ v ) )] : ( Q @ Cfg @ FStepCfg @ FStepMsg @ ( zero_zero @ nat ) )
         => ( ! [Cfg: configuration_ext @ p @ v @ s @ product_unit,FStepCfg: ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ),FStepMsg: ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( message @ p @ v ) ),N: nat] :
                ( ( P2 @ Cfg @ FStepCfg @ FStepMsg @ N )
               => ( ( Q @ Cfg @ FStepCfg @ FStepMsg @ N )
                 => ( Q @ Cfg @ FStepCfg @ FStepMsg @ ( suc @ N ) ) ) )
           => ( P2 @ A0 @ A1 @ A2 @ A3 ) ) ) ) ) ).

% infiniteExecutionCfg_infiniteExecutionMsg.induct(1)
thf(fact_12_prefixList_Ointros_I1_J,axiom,
    ! [A: $tType,X: A,Xs: list @ A] : ( prefixList @ A @ ( nil @ A ) @ ( cons @ A @ X @ Xs ) ) ).

% prefixList.intros(1)
thf(fact_13_prefixList_Ocases,axiom,
    ! [A: $tType,A1: list @ A,A2: list @ A] :
      ( ( prefixList @ A @ A1 @ A2 )
     => ( ( ( A1
            = ( nil @ A ) )
         => ! [X2: A,Xs2: list @ A] :
              ( A2
             != ( cons @ A @ X2 @ Xs2 ) ) )
       => ~ ! [Xa2: list @ A,Xb2: list @ A,X2: A] :
              ( ( A1
                = ( cons @ A @ X2 @ Xa2 ) )
             => ( ( A2
                  = ( cons @ A @ X2 @ Xb2 ) )
               => ~ ( prefixList @ A @ Xa2 @ Xb2 ) ) ) ) ) ).

% prefixList.cases
thf(fact_14_prefixList_Osimps,axiom,
    ! [A: $tType] :
      ( ( prefixList @ A )
      = ( ^ [A12: list @ A,A22: list @ A] :
            ( ? [X3: A,Xs3: list @ A] :
                ( ( A12
                  = ( nil @ A ) )
                & ( A22
                  = ( cons @ A @ X3 @ Xs3 ) ) )
            | ? [Xa3: list @ A,Xb3: list @ A,X3: A] :
                ( ( A12
                  = ( cons @ A @ X3 @ Xa3 ) )
                & ( A22
                  = ( cons @ A @ X3 @ Xb3 ) )
                & ( prefixList @ A @ Xa3 @ Xb3 ) ) ) ) ) ).

% prefixList.simps
thf(fact_15_prefixList_Oinducts,axiom,
    ! [A: $tType,X1: list @ A,X22: list @ A,P2: ( list @ A ) > ( list @ A ) > $o] :
      ( ( prefixList @ A @ X1 @ X22 )
     => ( ! [X2: A,Xs2: list @ A] : ( P2 @ ( nil @ A ) @ ( cons @ A @ X2 @ Xs2 ) )
       => ( ! [Xa2: list @ A,Xb2: list @ A,X2: A] :
              ( ( prefixList @ A @ Xa2 @ Xb2 )
             => ( ( P2 @ Xa2 @ Xb2 )
               => ( P2 @ ( cons @ A @ X2 @ Xa2 ) @ ( cons @ A @ X2 @ Xb2 ) ) ) )
         => ( P2 @ X1 @ X22 ) ) ) ) ).

% prefixList.inducts
thf(fact_16_NatPredicateTippingPoint,axiom,
    ! [N2: nat,Pr: nat > $o] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ N2 )
     => ( ( Pr @ ( zero_zero @ nat ) )
       => ( ~ ( Pr @ N2 )
         => ? [N: nat] :
              ( ( ord_less @ nat @ N @ N2 )
              & ( Pr @ N )
              & ~ ( Pr @ ( suc @ N ) ) ) ) ) ) ).

% NatPredicateTippingPoint
thf(fact_17_infiniteExecutionCfg_Osimps_I1_J,axiom,
    ! [Cfg2: configuration_ext @ p @ v @ s @ product_unit,FStepCfg2: ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ),FStepMsg2: ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( message @ p @ v ) )] :
      ( ( fLPThe137922386ionCfg @ p @ v @ s @ Cfg2 @ FStepCfg2 @ FStepMsg2 @ ( zero_zero @ nat ) )
      = ( cons @ ( configuration_ext @ p @ v @ s @ product_unit ) @ Cfg2 @ ( nil @ ( configuration_ext @ p @ v @ s @ product_unit ) ) ) ) ).

% infiniteExecutionCfg.simps(1)
thf(fact_18_length__greater__0__conv,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ ( size_size @ ( list @ A ) @ Xs ) )
      = ( Xs
       != ( nil @ A ) ) ) ).

% length_greater_0_conv
thf(fact_19_length__0__conv,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( ( size_size @ ( list @ A ) @ Xs )
        = ( zero_zero @ nat ) )
      = ( Xs
        = ( nil @ A ) ) ) ).

% length_0_conv
thf(fact_20_less__Suc0,axiom,
    ! [N3: nat] :
      ( ( ord_less @ nat @ N3 @ ( suc @ ( zero_zero @ nat ) ) )
      = ( N3
        = ( zero_zero @ nat ) ) ) ).

% less_Suc0
thf(fact_21_zero__less__Suc,axiom,
    ! [N3: nat] : ( ord_less @ nat @ ( zero_zero @ nat ) @ ( suc @ N3 ) ) ).

% zero_less_Suc
thf(fact_22_lessI,axiom,
    ! [N3: nat] : ( ord_less @ nat @ N3 @ ( suc @ N3 ) ) ).

% lessI
thf(fact_23_Suc__mono,axiom,
    ! [M: nat,N3: nat] :
      ( ( ord_less @ nat @ M @ N3 )
     => ( ord_less @ nat @ ( suc @ M ) @ ( suc @ N3 ) ) ) ).

% Suc_mono
thf(fact_24_Suc__less__eq,axiom,
    ! [M: nat,N3: nat] :
      ( ( ord_less @ nat @ ( suc @ M ) @ ( suc @ N3 ) )
      = ( ord_less @ nat @ M @ N3 ) ) ).

% Suc_less_eq
thf(fact_25_neq0__conv,axiom,
    ! [N3: nat] :
      ( ( N3
       != ( zero_zero @ nat ) )
      = ( ord_less @ nat @ ( zero_zero @ nat ) @ N3 ) ) ).

% neq0_conv
thf(fact_26_less__nat__zero__code,axiom,
    ! [N3: nat] :
      ~ ( ord_less @ nat @ N3 @ ( zero_zero @ nat ) ) ).

% less_nat_zero_code
thf(fact_27_bot__nat__0_Onot__eq__extremum,axiom,
    ! [A8: nat] :
      ( ( A8
       != ( zero_zero @ nat ) )
      = ( ord_less @ nat @ ( zero_zero @ nat ) @ A8 ) ) ).

% bot_nat_0.not_eq_extremum
thf(fact_28_list_Oinject,axiom,
    ! [A: $tType,X21: A,X222: list @ A,Y21: A,Y22: list @ A] :
      ( ( ( cons @ A @ X21 @ X222 )
        = ( cons @ A @ Y21 @ Y22 ) )
      = ( ( X21 = Y21 )
        & ( X222 = Y22 ) ) ) ).

% list.inject
thf(fact_29_old_Onat_Oinject,axiom,
    ! [Nat: nat,Nat2: nat] :
      ( ( ( suc @ Nat )
        = ( suc @ Nat2 ) )
      = ( Nat = Nat2 ) ) ).

% old.nat.inject
thf(fact_30_nat_Oinject,axiom,
    ! [X22: nat,Y2: nat] :
      ( ( ( suc @ X22 )
        = ( suc @ Y2 ) )
      = ( X22 = Y2 ) ) ).

% nat.inject
thf(fact_31_measure__induct__rule,axiom,
    ! [B: $tType,A: $tType] :
      ( ( wellorder @ B )
     => ! [F: A > B,P2: A > $o,A8: A] :
          ( ! [X2: A] :
              ( ! [Y: A] :
                  ( ( ord_less @ B @ ( F @ Y ) @ ( F @ X2 ) )
                 => ( P2 @ Y ) )
             => ( P2 @ X2 ) )
         => ( P2 @ A8 ) ) ) ).

% measure_induct_rule
thf(fact_32_measure__induct,axiom,
    ! [B: $tType,A: $tType] :
      ( ( wellorder @ B )
     => ! [F: A > B,P2: A > $o,A8: A] :
          ( ! [X2: A] :
              ( ! [Y: A] :
                  ( ( ord_less @ B @ ( F @ Y ) @ ( F @ X2 ) )
                 => ( P2 @ Y ) )
             => ( P2 @ X2 ) )
         => ( P2 @ A8 ) ) ) ).

% measure_induct
thf(fact_33_not__Cons__self2,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( cons @ A @ X @ Xs )
     != Xs ) ).

% not_Cons_self2
thf(fact_34_n__not__Suc__n,axiom,
    ! [N3: nat] :
      ( N3
     != ( suc @ N3 ) ) ).

% n_not_Suc_n
thf(fact_35_Suc__inject,axiom,
    ! [X: nat,Y3: nat] :
      ( ( ( suc @ X )
        = ( suc @ Y3 ) )
     => ( X = Y3 ) ) ).

% Suc_inject
thf(fact_36_infinite__descent__measure,axiom,
    ! [A: $tType,P2: A > $o,V2: A > nat,X: A] :
      ( ! [X2: A] :
          ( ~ ( P2 @ X2 )
         => ? [Y: A] :
              ( ( ord_less @ nat @ ( V2 @ Y ) @ ( V2 @ X2 ) )
              & ~ ( P2 @ Y ) ) )
     => ( P2 @ X ) ) ).

% infinite_descent_measure
thf(fact_37_linorder__neqE__nat,axiom,
    ! [X: nat,Y3: nat] :
      ( ( X != Y3 )
     => ( ~ ( ord_less @ nat @ X @ Y3 )
       => ( ord_less @ nat @ Y3 @ X ) ) ) ).

% linorder_neqE_nat
thf(fact_38_infinite__descent,axiom,
    ! [P2: nat > $o,N3: nat] :
      ( ! [N: nat] :
          ( ~ ( P2 @ N )
         => ? [M2: nat] :
              ( ( ord_less @ nat @ M2 @ N )
              & ~ ( P2 @ M2 ) ) )
     => ( P2 @ N3 ) ) ).

% infinite_descent
thf(fact_39_nat__less__induct,axiom,
    ! [P2: nat > $o,N3: nat] :
      ( ! [N: nat] :
          ( ! [M2: nat] :
              ( ( ord_less @ nat @ M2 @ N )
             => ( P2 @ M2 ) )
         => ( P2 @ N ) )
     => ( P2 @ N3 ) ) ).

% nat_less_induct
thf(fact_40_less__irrefl__nat,axiom,
    ! [N3: nat] :
      ~ ( ord_less @ nat @ N3 @ N3 ) ).

% less_irrefl_nat
thf(fact_41_less__not__refl3,axiom,
    ! [S2: nat,T: nat] :
      ( ( ord_less @ nat @ S2 @ T )
     => ( S2 != T ) ) ).

% less_not_refl3
thf(fact_42_less__not__refl2,axiom,
    ! [N3: nat,M: nat] :
      ( ( ord_less @ nat @ N3 @ M )
     => ( M != N3 ) ) ).

% less_not_refl2
thf(fact_43_mem__Collect__eq,axiom,
    ! [A: $tType,A8: A,P2: A > $o] :
      ( ( member @ A @ A8 @ ( collect @ A @ P2 ) )
      = ( P2 @ A8 ) ) ).

% mem_Collect_eq
thf(fact_44_Collect__mem__eq,axiom,
    ! [A: $tType,A9: set @ A] :
      ( ( collect @ A
        @ ^ [X3: A] : ( member @ A @ X3 @ A9 ) )
      = A9 ) ).

% Collect_mem_eq
thf(fact_45_Collect__cong,axiom,
    ! [A: $tType,P2: A > $o,Q: A > $o] :
      ( ! [X2: A] :
          ( ( P2 @ X2 )
          = ( Q @ X2 ) )
     => ( ( collect @ A @ P2 )
        = ( collect @ A @ Q ) ) ) ).

% Collect_cong
thf(fact_46_ext,axiom,
    ! [B: $tType,A: $tType,F: A > B,G: A > B] :
      ( ! [X2: A] :
          ( ( F @ X2 )
          = ( G @ X2 ) )
     => ( F = G ) ) ).

% ext
thf(fact_47_less__not__refl,axiom,
    ! [N3: nat] :
      ~ ( ord_less @ nat @ N3 @ N3 ) ).

% less_not_refl
thf(fact_48_nat__neq__iff,axiom,
    ! [M: nat,N3: nat] :
      ( ( M != N3 )
      = ( ( ord_less @ nat @ M @ N3 )
        | ( ord_less @ nat @ N3 @ M ) ) ) ).

% nat_neq_iff
thf(fact_49_size__neq__size__imp__neq,axiom,
    ! [A: $tType] :
      ( ( size @ A )
     => ! [X: A,Y3: A] :
          ( ( ( size_size @ A @ X )
           != ( size_size @ A @ Y3 ) )
         => ( X != Y3 ) ) ) ).

% size_neq_size_imp_neq
thf(fact_50_neq__if__length__neq,axiom,
    ! [A: $tType,Xs: list @ A,Ys: list @ A] :
      ( ( ( size_size @ ( list @ A ) @ Xs )
       != ( size_size @ ( list @ A ) @ Ys ) )
     => ( Xs != Ys ) ) ).

% neq_if_length_neq
thf(fact_51_Ex__list__of__length,axiom,
    ! [A: $tType,N3: nat] :
    ? [Xs2: list @ A] :
      ( ( size_size @ ( list @ A ) @ Xs2 )
      = N3 ) ).

% Ex_list_of_length
thf(fact_52_not0__implies__Suc,axiom,
    ! [N3: nat] :
      ( ( N3
       != ( zero_zero @ nat ) )
     => ? [M3: nat] :
          ( N3
          = ( suc @ M3 ) ) ) ).

% not0_implies_Suc
thf(fact_53_old_Onat_Oinducts,axiom,
    ! [P2: nat > $o,Nat: nat] :
      ( ( P2 @ ( zero_zero @ nat ) )
     => ( ! [Nat3: nat] :
            ( ( P2 @ Nat3 )
           => ( P2 @ ( suc @ Nat3 ) ) )
       => ( P2 @ Nat ) ) ) ).

% old.nat.inducts
thf(fact_54_old_Onat_Oexhaust,axiom,
    ! [Y3: nat] :
      ( ( Y3
       != ( zero_zero @ nat ) )
     => ~ ! [Nat3: nat] :
            ( Y3
           != ( suc @ Nat3 ) ) ) ).

% old.nat.exhaust
thf(fact_55_Zero__not__Suc,axiom,
    ! [M: nat] :
      ( ( zero_zero @ nat )
     != ( suc @ M ) ) ).

% Zero_not_Suc
thf(fact_56_Zero__neq__Suc,axiom,
    ! [M: nat] :
      ( ( zero_zero @ nat )
     != ( suc @ M ) ) ).

% Zero_neq_Suc
thf(fact_57_Suc__neq__Zero,axiom,
    ! [M: nat] :
      ( ( suc @ M )
     != ( zero_zero @ nat ) ) ).

% Suc_neq_Zero
thf(fact_58_zero__induct,axiom,
    ! [P2: nat > $o,K: nat] :
      ( ( P2 @ K )
     => ( ! [N: nat] :
            ( ( P2 @ ( suc @ N ) )
           => ( P2 @ N ) )
       => ( P2 @ ( zero_zero @ nat ) ) ) ) ).

% zero_induct
thf(fact_59_diff__induct,axiom,
    ! [P2: nat > nat > $o,M: nat,N3: nat] :
      ( ! [X2: nat] : ( P2 @ X2 @ ( zero_zero @ nat ) )
     => ( ! [Y4: nat] : ( P2 @ ( zero_zero @ nat ) @ ( suc @ Y4 ) )
       => ( ! [X2: nat,Y4: nat] :
              ( ( P2 @ X2 @ Y4 )
             => ( P2 @ ( suc @ X2 ) @ ( suc @ Y4 ) ) )
         => ( P2 @ M @ N3 ) ) ) ) ).

% diff_induct
thf(fact_60_nat__induct,axiom,
    ! [P2: nat > $o,N3: nat] :
      ( ( P2 @ ( zero_zero @ nat ) )
     => ( ! [N: nat] :
            ( ( P2 @ N )
           => ( P2 @ ( suc @ N ) ) )
       => ( P2 @ N3 ) ) ) ).

% nat_induct
thf(fact_61_nat_OdiscI,axiom,
    ! [Nat: nat,X22: nat] :
      ( ( Nat
        = ( suc @ X22 ) )
     => ( Nat
       != ( zero_zero @ nat ) ) ) ).

% nat.discI
thf(fact_62_old_Onat_Odistinct_I1_J,axiom,
    ! [Nat2: nat] :
      ( ( zero_zero @ nat )
     != ( suc @ Nat2 ) ) ).

% old.nat.distinct(1)
thf(fact_63_old_Onat_Odistinct_I2_J,axiom,
    ! [Nat4: nat] :
      ( ( suc @ Nat4 )
     != ( zero_zero @ nat ) ) ).

% old.nat.distinct(2)
thf(fact_64_nat_Odistinct_I1_J,axiom,
    ! [X22: nat] :
      ( ( zero_zero @ nat )
     != ( suc @ X22 ) ) ).

% nat.distinct(1)
thf(fact_65_infinite__descent0__measure,axiom,
    ! [A: $tType,V2: A > nat,P2: A > $o,X: A] :
      ( ! [X2: A] :
          ( ( ( V2 @ X2 )
            = ( zero_zero @ nat ) )
         => ( P2 @ X2 ) )
     => ( ! [X2: A] :
            ( ( ord_less @ nat @ ( zero_zero @ nat ) @ ( V2 @ X2 ) )
           => ( ~ ( P2 @ X2 )
             => ? [Y: A] :
                  ( ( ord_less @ nat @ ( V2 @ Y ) @ ( V2 @ X2 ) )
                  & ~ ( P2 @ Y ) ) ) )
       => ( P2 @ X ) ) ) ).

% infinite_descent0_measure
thf(fact_66_bot__nat__0_Oextremum__strict,axiom,
    ! [A8: nat] :
      ~ ( ord_less @ nat @ A8 @ ( zero_zero @ nat ) ) ).

% bot_nat_0.extremum_strict
thf(fact_67_infinite__descent0,axiom,
    ! [P2: nat > $o,N3: nat] :
      ( ( P2 @ ( zero_zero @ nat ) )
     => ( ! [N: nat] :
            ( ( ord_less @ nat @ ( zero_zero @ nat ) @ N )
           => ( ~ ( P2 @ N )
             => ? [M2: nat] :
                  ( ( ord_less @ nat @ M2 @ N )
                  & ~ ( P2 @ M2 ) ) ) )
       => ( P2 @ N3 ) ) ) ).

% infinite_descent0
thf(fact_68_gr__implies__not0,axiom,
    ! [M: nat,N3: nat] :
      ( ( ord_less @ nat @ M @ N3 )
     => ( N3
       != ( zero_zero @ nat ) ) ) ).

% gr_implies_not0
thf(fact_69_less__zeroE,axiom,
    ! [N3: nat] :
      ~ ( ord_less @ nat @ N3 @ ( zero_zero @ nat ) ) ).

% less_zeroE
thf(fact_70_not__less0,axiom,
    ! [N3: nat] :
      ~ ( ord_less @ nat @ N3 @ ( zero_zero @ nat ) ) ).

% not_less0
thf(fact_71_not__gr0,axiom,
    ! [N3: nat] :
      ( ( ~ ( ord_less @ nat @ ( zero_zero @ nat ) @ N3 ) )
      = ( N3
        = ( zero_zero @ nat ) ) ) ).

% not_gr0
thf(fact_72_gr0I,axiom,
    ! [N3: nat] :
      ( ( N3
       != ( zero_zero @ nat ) )
     => ( ord_less @ nat @ ( zero_zero @ nat ) @ N3 ) ) ).

% gr0I
thf(fact_73_not__less__less__Suc__eq,axiom,
    ! [N3: nat,M: nat] :
      ( ~ ( ord_less @ nat @ N3 @ M )
     => ( ( ord_less @ nat @ N3 @ ( suc @ M ) )
        = ( N3 = M ) ) ) ).

% not_less_less_Suc_eq
thf(fact_74_strict__inc__induct,axiom,
    ! [I: nat,J: nat,P2: nat > $o] :
      ( ( ord_less @ nat @ I @ J )
     => ( ! [I2: nat] :
            ( ( J
              = ( suc @ I2 ) )
           => ( P2 @ I2 ) )
       => ( ! [I2: nat] :
              ( ( ord_less @ nat @ I2 @ J )
             => ( ( P2 @ ( suc @ I2 ) )
               => ( P2 @ I2 ) ) )
         => ( P2 @ I ) ) ) ) ).

% strict_inc_induct
thf(fact_75_less__Suc__induct,axiom,
    ! [I: nat,J: nat,P2: nat > nat > $o] :
      ( ( ord_less @ nat @ I @ J )
     => ( ! [I2: nat] : ( P2 @ I2 @ ( suc @ I2 ) )
       => ( ! [I2: nat,J2: nat,K2: nat] :
              ( ( ord_less @ nat @ I2 @ J2 )
             => ( ( ord_less @ nat @ J2 @ K2 )
               => ( ( P2 @ I2 @ J2 )
                 => ( ( P2 @ J2 @ K2 )
                   => ( P2 @ I2 @ K2 ) ) ) ) )
         => ( P2 @ I @ J ) ) ) ) ).

% less_Suc_induct
thf(fact_76_less__trans__Suc,axiom,
    ! [I: nat,J: nat,K: nat] :
      ( ( ord_less @ nat @ I @ J )
     => ( ( ord_less @ nat @ J @ K )
       => ( ord_less @ nat @ ( suc @ I ) @ K ) ) ) ).

% less_trans_Suc
thf(fact_77_Suc__less__SucD,axiom,
    ! [M: nat,N3: nat] :
      ( ( ord_less @ nat @ ( suc @ M ) @ ( suc @ N3 ) )
     => ( ord_less @ nat @ M @ N3 ) ) ).

% Suc_less_SucD
thf(fact_78_less__antisym,axiom,
    ! [N3: nat,M: nat] :
      ( ~ ( ord_less @ nat @ N3 @ M )
     => ( ( ord_less @ nat @ N3 @ ( suc @ M ) )
       => ( M = N3 ) ) ) ).

% less_antisym
thf(fact_79_Suc__less__eq2,axiom,
    ! [N3: nat,M: nat] :
      ( ( ord_less @ nat @ ( suc @ N3 ) @ M )
      = ( ? [M4: nat] :
            ( ( M
              = ( suc @ M4 ) )
            & ( ord_less @ nat @ N3 @ M4 ) ) ) ) ).

% Suc_less_eq2
thf(fact_80_All__less__Suc,axiom,
    ! [N3: nat,P2: nat > $o] :
      ( ( ! [I3: nat] :
            ( ( ord_less @ nat @ I3 @ ( suc @ N3 ) )
           => ( P2 @ I3 ) ) )
      = ( ( P2 @ N3 )
        & ! [I3: nat] :
            ( ( ord_less @ nat @ I3 @ N3 )
           => ( P2 @ I3 ) ) ) ) ).

% All_less_Suc
thf(fact_81_not__less__eq,axiom,
    ! [M: nat,N3: nat] :
      ( ( ~ ( ord_less @ nat @ M @ N3 ) )
      = ( ord_less @ nat @ N3 @ ( suc @ M ) ) ) ).

% not_less_eq
thf(fact_82_less__Suc__eq,axiom,
    ! [M: nat,N3: nat] :
      ( ( ord_less @ nat @ M @ ( suc @ N3 ) )
      = ( ( ord_less @ nat @ M @ N3 )
        | ( M = N3 ) ) ) ).

% less_Suc_eq
thf(fact_83_Ex__less__Suc,axiom,
    ! [N3: nat,P2: nat > $o] :
      ( ( ? [I3: nat] :
            ( ( ord_less @ nat @ I3 @ ( suc @ N3 ) )
            & ( P2 @ I3 ) ) )
      = ( ( P2 @ N3 )
        | ? [I3: nat] :
            ( ( ord_less @ nat @ I3 @ N3 )
            & ( P2 @ I3 ) ) ) ) ).

% Ex_less_Suc
thf(fact_84_less__SucI,axiom,
    ! [M: nat,N3: nat] :
      ( ( ord_less @ nat @ M @ N3 )
     => ( ord_less @ nat @ M @ ( suc @ N3 ) ) ) ).

% less_SucI
thf(fact_85_less__SucE,axiom,
    ! [M: nat,N3: nat] :
      ( ( ord_less @ nat @ M @ ( suc @ N3 ) )
     => ( ~ ( ord_less @ nat @ M @ N3 )
       => ( M = N3 ) ) ) ).

% less_SucE
thf(fact_86_Suc__lessI,axiom,
    ! [M: nat,N3: nat] :
      ( ( ord_less @ nat @ M @ N3 )
     => ( ( ( suc @ M )
         != N3 )
       => ( ord_less @ nat @ ( suc @ M ) @ N3 ) ) ) ).

% Suc_lessI
thf(fact_87_Suc__lessE,axiom,
    ! [I: nat,K: nat] :
      ( ( ord_less @ nat @ ( suc @ I ) @ K )
     => ~ ! [J2: nat] :
            ( ( ord_less @ nat @ I @ J2 )
           => ( K
             != ( suc @ J2 ) ) ) ) ).

% Suc_lessE
thf(fact_88_Suc__lessD,axiom,
    ! [M: nat,N3: nat] :
      ( ( ord_less @ nat @ ( suc @ M ) @ N3 )
     => ( ord_less @ nat @ M @ N3 ) ) ).

% Suc_lessD
thf(fact_89_Nat_OlessE,axiom,
    ! [I: nat,K: nat] :
      ( ( ord_less @ nat @ I @ K )
     => ( ( K
         != ( suc @ I ) )
       => ~ ! [J2: nat] :
              ( ( ord_less @ nat @ I @ J2 )
             => ( K
               != ( suc @ J2 ) ) ) ) ) ).

% Nat.lessE
thf(fact_90_strict__sorted_Oinduct,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [P2: ( list @ A ) > $o,A0: list @ A] :
          ( ( P2 @ ( nil @ A ) )
         => ( ! [X2: A,Ys2: list @ A] :
                ( ( P2 @ Ys2 )
               => ( P2 @ ( cons @ A @ X2 @ Ys2 ) ) )
           => ( P2 @ A0 ) ) ) ) ).

% strict_sorted.induct
thf(fact_91_strict__sorted_Ocases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X: list @ A] :
          ( ( X
           != ( nil @ A ) )
         => ~ ! [X2: A,Ys2: list @ A] :
                ( X
               != ( cons @ A @ X2 @ Ys2 ) ) ) ) ).

% strict_sorted.cases
thf(fact_92_map__tailrec__rev_Oinduct,axiom,
    ! [A: $tType,B: $tType,P2: ( A > B ) > ( list @ A ) > ( list @ B ) > $o,A0: A > B,A1: list @ A,A2: list @ B] :
      ( ! [F2: A > B,X_1: list @ B] : ( P2 @ F2 @ ( nil @ A ) @ X_1 )
     => ( ! [F2: A > B,A10: A,As: list @ A,Bs: list @ B] :
            ( ( P2 @ F2 @ As @ ( cons @ B @ ( F2 @ A10 ) @ Bs ) )
           => ( P2 @ F2 @ ( cons @ A @ A10 @ As ) @ Bs ) )
       => ( P2 @ A0 @ A1 @ A2 ) ) ) ).

% map_tailrec_rev.induct
thf(fact_93_list__nonempty__induct,axiom,
    ! [A: $tType,Xs: list @ A,P2: ( list @ A ) > $o] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ! [X2: A] : ( P2 @ ( cons @ A @ X2 @ ( nil @ A ) ) )
       => ( ! [X2: A,Xs2: list @ A] :
              ( ( Xs2
               != ( nil @ A ) )
             => ( ( P2 @ Xs2 )
               => ( P2 @ ( cons @ A @ X2 @ Xs2 ) ) ) )
         => ( P2 @ Xs ) ) ) ) ).

% list_nonempty_induct
thf(fact_94_successively_Oinduct,axiom,
    ! [A: $tType,P2: ( A > A > $o ) > ( list @ A ) > $o,A0: A > A > $o,A1: list @ A] :
      ( ! [P3: A > A > $o] : ( P2 @ P3 @ ( nil @ A ) )
     => ( ! [P3: A > A > $o,X2: A] : ( P2 @ P3 @ ( cons @ A @ X2 @ ( nil @ A ) ) )
       => ( ! [P3: A > A > $o,X2: A,Y4: A,Xs2: list @ A] :
              ( ( P2 @ P3 @ ( cons @ A @ Y4 @ Xs2 ) )
             => ( P2 @ P3 @ ( cons @ A @ X2 @ ( cons @ A @ Y4 @ Xs2 ) ) ) )
         => ( P2 @ A0 @ A1 ) ) ) ) ).

% successively.induct
thf(fact_95_arg__min__list_Oinduct,axiom,
    ! [B: $tType,A: $tType] :
      ( ( linorder @ B )
     => ! [P2: ( A > B ) > ( list @ A ) > $o,A0: A > B,A1: list @ A] :
          ( ! [F2: A > B,X2: A] : ( P2 @ F2 @ ( cons @ A @ X2 @ ( nil @ A ) ) )
         => ( ! [F2: A > B,X2: A,Y4: A,Zs: list @ A] :
                ( ( P2 @ F2 @ ( cons @ A @ Y4 @ Zs ) )
               => ( P2 @ F2 @ ( cons @ A @ X2 @ ( cons @ A @ Y4 @ Zs ) ) ) )
           => ( ! [A10: A > B] : ( P2 @ A10 @ ( nil @ A ) )
             => ( P2 @ A0 @ A1 ) ) ) ) ) ).

% arg_min_list.induct
thf(fact_96_remdups__adj_Oinduct,axiom,
    ! [A: $tType,P2: ( list @ A ) > $o,A0: list @ A] :
      ( ( P2 @ ( nil @ A ) )
     => ( ! [X2: A] : ( P2 @ ( cons @ A @ X2 @ ( nil @ A ) ) )
       => ( ! [X2: A,Y4: A,Xs2: list @ A] :
              ( ( ( X2 = Y4 )
               => ( P2 @ ( cons @ A @ X2 @ Xs2 ) ) )
             => ( ( ( X2 != Y4 )
                 => ( P2 @ ( cons @ A @ Y4 @ Xs2 ) ) )
               => ( P2 @ ( cons @ A @ X2 @ ( cons @ A @ Y4 @ Xs2 ) ) ) ) )
         => ( P2 @ A0 ) ) ) ) ).

% remdups_adj.induct
thf(fact_97_sorted__wrt_Oinduct,axiom,
    ! [A: $tType,P2: ( A > A > $o ) > ( list @ A ) > $o,A0: A > A > $o,A1: list @ A] :
      ( ! [P3: A > A > $o] : ( P2 @ P3 @ ( nil @ A ) )
     => ( ! [P3: A > A > $o,X2: A,Ys2: list @ A] :
            ( ( P2 @ P3 @ Ys2 )
           => ( P2 @ P3 @ ( cons @ A @ X2 @ Ys2 ) ) )
       => ( P2 @ A0 @ A1 ) ) ) ).

% sorted_wrt.induct
thf(fact_98_remdups__adj_Ocases,axiom,
    ! [A: $tType,X: list @ A] :
      ( ( X
       != ( nil @ A ) )
     => ( ! [X2: A] :
            ( X
           != ( cons @ A @ X2 @ ( nil @ A ) ) )
       => ~ ! [X2: A,Y4: A,Xs2: list @ A] :
              ( X
             != ( cons @ A @ X2 @ ( cons @ A @ Y4 @ Xs2 ) ) ) ) ) ).

% remdups_adj.cases
thf(fact_99_transpose_Ocases,axiom,
    ! [A: $tType,X: list @ ( list @ A )] :
      ( ( X
       != ( nil @ ( list @ A ) ) )
     => ( ! [Xss: list @ ( list @ A )] :
            ( X
           != ( cons @ ( list @ A ) @ ( nil @ A ) @ Xss ) )
       => ~ ! [X2: A,Xs2: list @ A,Xss: list @ ( list @ A )] :
              ( X
             != ( cons @ ( list @ A ) @ ( cons @ A @ X2 @ Xs2 ) @ Xss ) ) ) ) ).

% transpose.cases
thf(fact_100_shuffles_Oinduct,axiom,
    ! [A: $tType,P2: ( list @ A ) > ( list @ A ) > $o,A0: list @ A,A1: list @ A] :
      ( ! [X_1: list @ A] : ( P2 @ ( nil @ A ) @ X_1 )
     => ( ! [Xs2: list @ A] : ( P2 @ Xs2 @ ( nil @ A ) )
       => ( ! [X2: A,Xs2: list @ A,Y4: A,Ys2: list @ A] :
              ( ( P2 @ Xs2 @ ( cons @ A @ Y4 @ Ys2 ) )
             => ( ( P2 @ ( cons @ A @ X2 @ Xs2 ) @ Ys2 )
               => ( P2 @ ( cons @ A @ X2 @ Xs2 ) @ ( cons @ A @ Y4 @ Ys2 ) ) ) )
         => ( P2 @ A0 @ A1 ) ) ) ) ).

% shuffles.induct
thf(fact_101_min__list_Oinduct,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [P2: ( list @ A ) > $o,A0: list @ A] :
          ( ! [X2: A,Xs2: list @ A] :
              ( ! [X212: A,X223: list @ A] :
                  ( ( Xs2
                    = ( cons @ A @ X212 @ X223 ) )
                 => ( P2 @ Xs2 ) )
             => ( P2 @ ( cons @ A @ X2 @ Xs2 ) ) )
         => ( ( P2 @ ( nil @ A ) )
           => ( P2 @ A0 ) ) ) ) ).

% min_list.induct
thf(fact_102_min__list_Ocases,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [X: list @ A] :
          ( ! [X2: A,Xs2: list @ A] :
              ( X
             != ( cons @ A @ X2 @ Xs2 ) )
         => ( X
            = ( nil @ A ) ) ) ) ).

% min_list.cases
thf(fact_103_induct__list012,axiom,
    ! [A: $tType,P2: ( list @ A ) > $o,Xs: list @ A] :
      ( ( P2 @ ( nil @ A ) )
     => ( ! [X2: A] : ( P2 @ ( cons @ A @ X2 @ ( nil @ A ) ) )
       => ( ! [X2: A,Y4: A,Zs: list @ A] :
              ( ( P2 @ Zs )
             => ( ( P2 @ ( cons @ A @ Y4 @ Zs ) )
               => ( P2 @ ( cons @ A @ X2 @ ( cons @ A @ Y4 @ Zs ) ) ) ) )
         => ( P2 @ Xs ) ) ) ) ).

% induct_list012
thf(fact_104_splice_Oinduct,axiom,
    ! [A: $tType,P2: ( list @ A ) > ( list @ A ) > $o,A0: list @ A,A1: list @ A] :
      ( ! [X_1: list @ A] : ( P2 @ ( nil @ A ) @ X_1 )
     => ( ! [X2: A,Xs2: list @ A,Ys2: list @ A] :
            ( ( P2 @ Ys2 @ Xs2 )
           => ( P2 @ ( cons @ A @ X2 @ Xs2 ) @ Ys2 ) )
       => ( P2 @ A0 @ A1 ) ) ) ).

% splice.induct
thf(fact_105_list__induct2_H,axiom,
    ! [A: $tType,B: $tType,P2: ( list @ A ) > ( list @ B ) > $o,Xs: list @ A,Ys: list @ B] :
      ( ( P2 @ ( nil @ A ) @ ( nil @ B ) )
     => ( ! [X2: A,Xs2: list @ A] : ( P2 @ ( cons @ A @ X2 @ Xs2 ) @ ( nil @ B ) )
       => ( ! [Y4: B,Ys2: list @ B] : ( P2 @ ( nil @ A ) @ ( cons @ B @ Y4 @ Ys2 ) )
         => ( ! [X2: A,Xs2: list @ A,Y4: B,Ys2: list @ B] :
                ( ( P2 @ Xs2 @ Ys2 )
               => ( P2 @ ( cons @ A @ X2 @ Xs2 ) @ ( cons @ B @ Y4 @ Ys2 ) ) )
           => ( P2 @ Xs @ Ys ) ) ) ) ) ).

% list_induct2'
thf(fact_106_neq__Nil__conv,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
      = ( ? [Y5: A,Ys3: list @ A] :
            ( Xs
            = ( cons @ A @ Y5 @ Ys3 ) ) ) ) ).

% neq_Nil_conv
thf(fact_107_list_Oinducts,axiom,
    ! [A: $tType,P2: ( list @ A ) > $o,List: list @ A] :
      ( ( P2 @ ( nil @ A ) )
     => ( ! [X12: A,X23: list @ A] :
            ( ( P2 @ X23 )
           => ( P2 @ ( cons @ A @ X12 @ X23 ) ) )
       => ( P2 @ List ) ) ) ).

% list.inducts
thf(fact_108_list_Oexhaust,axiom,
    ! [A: $tType,Y3: list @ A] :
      ( ( Y3
       != ( nil @ A ) )
     => ~ ! [X213: A,X224: list @ A] :
            ( Y3
           != ( cons @ A @ X213 @ X224 ) ) ) ).

% list.exhaust
thf(fact_109_list_OdiscI,axiom,
    ! [A: $tType,List: list @ A,X21: A,X222: list @ A] :
      ( ( List
        = ( cons @ A @ X21 @ X222 ) )
     => ( List
       != ( nil @ A ) ) ) ).

% list.discI
thf(fact_110_list_Odistinct_I1_J,axiom,
    ! [A: $tType,X21: A,X222: list @ A] :
      ( ( nil @ A )
     != ( cons @ A @ X21 @ X222 ) ) ).

% list.distinct(1)
thf(fact_111_length__induct,axiom,
    ! [A: $tType,P2: ( list @ A ) > $o,Xs: list @ A] :
      ( ! [Xs2: list @ A] :
          ( ! [Ys4: list @ A] :
              ( ( ord_less @ nat @ ( size_size @ ( list @ A ) @ Ys4 ) @ ( size_size @ ( list @ A ) @ Xs2 ) )
             => ( P2 @ Ys4 ) )
         => ( P2 @ Xs2 ) )
     => ( P2 @ Xs ) ) ).

% length_induct
thf(fact_112_lift__Suc__mono__less__iff,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [F: nat > A,N3: nat,M: nat] :
          ( ! [N: nat] : ( ord_less @ A @ ( F @ N ) @ ( F @ ( suc @ N ) ) )
         => ( ( ord_less @ A @ ( F @ N3 ) @ ( F @ M ) )
            = ( ord_less @ nat @ N3 @ M ) ) ) ) ).

% lift_Suc_mono_less_iff
thf(fact_113_lift__Suc__mono__less,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [F: nat > A,N3: nat,N4: nat] :
          ( ! [N: nat] : ( ord_less @ A @ ( F @ N ) @ ( F @ ( suc @ N ) ) )
         => ( ( ord_less @ nat @ N3 @ N4 )
           => ( ord_less @ A @ ( F @ N3 ) @ ( F @ N4 ) ) ) ) ) ).

% lift_Suc_mono_less
thf(fact_114_less__Suc__eq__0__disj,axiom,
    ! [M: nat,N3: nat] :
      ( ( ord_less @ nat @ M @ ( suc @ N3 ) )
      = ( ( M
          = ( zero_zero @ nat ) )
        | ? [J3: nat] :
            ( ( M
              = ( suc @ J3 ) )
            & ( ord_less @ nat @ J3 @ N3 ) ) ) ) ).

% less_Suc_eq_0_disj
thf(fact_115_gr0__implies__Suc,axiom,
    ! [N3: nat] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ N3 )
     => ? [M3: nat] :
          ( N3
          = ( suc @ M3 ) ) ) ).

% gr0_implies_Suc
thf(fact_116_All__less__Suc2,axiom,
    ! [N3: nat,P2: nat > $o] :
      ( ( ! [I3: nat] :
            ( ( ord_less @ nat @ I3 @ ( suc @ N3 ) )
           => ( P2 @ I3 ) ) )
      = ( ( P2 @ ( zero_zero @ nat ) )
        & ! [I3: nat] :
            ( ( ord_less @ nat @ I3 @ N3 )
           => ( P2 @ ( suc @ I3 ) ) ) ) ) ).

% All_less_Suc2
thf(fact_117_gr0__conv__Suc,axiom,
    ! [N3: nat] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ N3 )
      = ( ? [M5: nat] :
            ( N3
            = ( suc @ M5 ) ) ) ) ).

% gr0_conv_Suc
thf(fact_118_Ex__less__Suc2,axiom,
    ! [N3: nat,P2: nat > $o] :
      ( ( ? [I3: nat] :
            ( ( ord_less @ nat @ I3 @ ( suc @ N3 ) )
            & ( P2 @ I3 ) ) )
      = ( ( P2 @ ( zero_zero @ nat ) )
        | ? [I3: nat] :
            ( ( ord_less @ nat @ I3 @ N3 )
            & ( P2 @ ( suc @ I3 ) ) ) ) ) ).

% Ex_less_Suc2
thf(fact_119_length__Suc__conv,axiom,
    ! [A: $tType,Xs: list @ A,N3: nat] :
      ( ( ( size_size @ ( list @ A ) @ Xs )
        = ( suc @ N3 ) )
      = ( ? [Y5: A,Ys3: list @ A] :
            ( ( Xs
              = ( cons @ A @ Y5 @ Ys3 ) )
            & ( ( size_size @ ( list @ A ) @ Ys3 )
              = N3 ) ) ) ) ).

% length_Suc_conv
thf(fact_120_Suc__length__conv,axiom,
    ! [A: $tType,N3: nat,Xs: list @ A] :
      ( ( ( suc @ N3 )
        = ( size_size @ ( list @ A ) @ Xs ) )
      = ( ? [Y5: A,Ys3: list @ A] :
            ( ( Xs
              = ( cons @ A @ Y5 @ Ys3 ) )
            & ( ( size_size @ ( list @ A ) @ Ys3 )
              = N3 ) ) ) ) ).

% Suc_length_conv
thf(fact_121_list_Osize_I3_J,axiom,
    ! [A: $tType] :
      ( ( size_size @ ( list @ A ) @ ( nil @ A ) )
      = ( zero_zero @ nat ) ) ).

% list.size(3)
thf(fact_122_list__induct3,axiom,
    ! [B: $tType,A: $tType,C: $tType,Xs: list @ A,Ys: list @ B,Zs2: list @ C,P2: ( list @ A ) > ( list @ B ) > ( list @ C ) > $o] :
      ( ( ( size_size @ ( list @ A ) @ Xs )
        = ( size_size @ ( list @ B ) @ Ys ) )
     => ( ( ( size_size @ ( list @ B ) @ Ys )
          = ( size_size @ ( list @ C ) @ Zs2 ) )
       => ( ( P2 @ ( nil @ A ) @ ( nil @ B ) @ ( nil @ C ) )
         => ( ! [X2: A,Xs2: list @ A,Y4: B,Ys2: list @ B,Z: C,Zs: list @ C] :
                ( ( ( size_size @ ( list @ A ) @ Xs2 )
                  = ( size_size @ ( list @ B ) @ Ys2 ) )
               => ( ( ( size_size @ ( list @ B ) @ Ys2 )
                    = ( size_size @ ( list @ C ) @ Zs ) )
                 => ( ( P2 @ Xs2 @ Ys2 @ Zs )
                   => ( P2 @ ( cons @ A @ X2 @ Xs2 ) @ ( cons @ B @ Y4 @ Ys2 ) @ ( cons @ C @ Z @ Zs ) ) ) ) )
           => ( P2 @ Xs @ Ys @ Zs2 ) ) ) ) ) ).

% list_induct3
thf(fact_123_list__induct2,axiom,
    ! [A: $tType,B: $tType,Xs: list @ A,Ys: list @ B,P2: ( list @ A ) > ( list @ B ) > $o] :
      ( ( ( size_size @ ( list @ A ) @ Xs )
        = ( size_size @ ( list @ B ) @ Ys ) )
     => ( ( P2 @ ( nil @ A ) @ ( nil @ B ) )
       => ( ! [X2: A,Xs2: list @ A,Y4: B,Ys2: list @ B] :
              ( ( ( size_size @ ( list @ A ) @ Xs2 )
                = ( size_size @ ( list @ B ) @ Ys2 ) )
             => ( ( P2 @ Xs2 @ Ys2 )
               => ( P2 @ ( cons @ A @ X2 @ Xs2 ) @ ( cons @ B @ Y4 @ Ys2 ) ) ) )
         => ( P2 @ Xs @ Ys ) ) ) ) ).

% list_induct2
thf(fact_124_infiniteExecutionCfg_Oelims,axiom,
    ! [X: configuration_ext @ p @ v @ s @ product_unit,Xa: ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ),Xb: ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( message @ p @ v ) ),Xc: nat,Y3: list @ ( configuration_ext @ p @ v @ s @ product_unit )] :
      ( ( ( fLPThe137922386ionCfg @ p @ v @ s @ X @ Xa @ Xb @ Xc )
        = Y3 )
     => ( ( ( Xc
            = ( zero_zero @ nat ) )
         => ( Y3
           != ( cons @ ( configuration_ext @ p @ v @ s @ product_unit ) @ X @ ( nil @ ( configuration_ext @ p @ v @ s @ product_unit ) ) ) ) )
       => ~ ! [N: nat] :
              ( ( Xc
                = ( suc @ N ) )
             => ( Y3
               != ( Xa @ ( fLPThe137922386ionCfg @ p @ v @ s @ X @ Xa @ Xb @ N ) @ ( fLPThe221390223ionMsg @ p @ v @ s @ X @ Xa @ Xb @ N ) ) ) ) ) ) ).

% infiniteExecutionCfg.elims
thf(fact_125_infiniteExecutionMsg_Oelims,axiom,
    ! [X: configuration_ext @ p @ v @ s @ product_unit,Xa: ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ),Xb: ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( message @ p @ v ) ),Xc: nat,Y3: list @ ( message @ p @ v )] :
      ( ( ( fLPThe221390223ionMsg @ p @ v @ s @ X @ Xa @ Xb @ Xc )
        = Y3 )
     => ( ( ( Xc
            = ( zero_zero @ nat ) )
         => ( Y3
           != ( nil @ ( message @ p @ v ) ) ) )
       => ~ ! [N: nat] :
              ( ( Xc
                = ( suc @ N ) )
             => ( Y3
               != ( Xb @ ( fLPThe137922386ionCfg @ p @ v @ s @ X @ Xa @ Xb @ N ) @ ( fLPThe221390223ionMsg @ p @ v @ s @ X @ Xa @ Xb @ N ) ) ) ) ) ) ).

% infiniteExecutionMsg.elims
thf(fact_126_infiniteExecutionMsg_Osimps_I2_J,axiom,
    ! [Cfg2: configuration_ext @ p @ v @ s @ product_unit,FStepCfg2: ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ),FStepMsg2: ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( message @ p @ v ) ),N3: nat] :
      ( ( fLPThe221390223ionMsg @ p @ v @ s @ Cfg2 @ FStepCfg2 @ FStepMsg2 @ ( suc @ N3 ) )
      = ( FStepMsg2 @ ( fLPThe137922386ionCfg @ p @ v @ s @ Cfg2 @ FStepCfg2 @ FStepMsg2 @ N3 ) @ ( fLPThe221390223ionMsg @ p @ v @ s @ Cfg2 @ FStepCfg2 @ FStepMsg2 @ N3 ) ) ) ).

% infiniteExecutionMsg.simps(2)
thf(fact_127_infiniteExecutionCfg_Osimps_I2_J,axiom,
    ! [Cfg2: configuration_ext @ p @ v @ s @ product_unit,FStepCfg2: ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ),FStepMsg2: ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( message @ p @ v ) ),N3: nat] :
      ( ( fLPThe137922386ionCfg @ p @ v @ s @ Cfg2 @ FStepCfg2 @ FStepMsg2 @ ( suc @ N3 ) )
      = ( FStepCfg2 @ ( fLPThe137922386ionCfg @ p @ v @ s @ Cfg2 @ FStepCfg2 @ FStepMsg2 @ N3 ) @ ( fLPThe221390223ionMsg @ p @ v @ s @ Cfg2 @ FStepCfg2 @ FStepMsg2 @ N3 ) ) ) ).

% infiniteExecutionCfg.simps(2)
thf(fact_128_infiniteExecutionMsg_Osimps_I1_J,axiom,
    ! [Cfg2: configuration_ext @ p @ v @ s @ product_unit,FStepCfg2: ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ),FStepMsg2: ( list @ ( configuration_ext @ p @ v @ s @ product_unit ) ) > ( list @ ( message @ p @ v ) ) > ( list @ ( message @ p @ v ) )] :
      ( ( fLPThe221390223ionMsg @ p @ v @ s @ Cfg2 @ FStepCfg2 @ FStepMsg2 @ ( zero_zero @ nat ) )
      = ( nil @ ( message @ p @ v ) ) ) ).

% infiniteExecutionMsg.simps(1)
thf(fact_129_not__gr__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N3: A] :
          ( ( ~ ( ord_less @ A @ ( zero_zero @ A ) @ N3 ) )
          = ( N3
            = ( zero_zero @ A ) ) ) ) ).

% not_gr_zero
thf(fact_130_length__Cons,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( size_size @ ( list @ A ) @ ( cons @ A @ X @ Xs ) )
      = ( suc @ ( size_size @ ( list @ A ) @ Xs ) ) ) ).

% length_Cons
thf(fact_131_dependent__nat__choice,axiom,
    ! [A: $tType,P2: nat > A > $o,Q: nat > A > A > $o] :
      ( ? [X_12: A] : ( P2 @ ( zero_zero @ nat ) @ X_12 )
     => ( ! [X2: A,N: nat] :
            ( ( P2 @ N @ X2 )
           => ? [Y: A] :
                ( ( P2 @ ( suc @ N ) @ Y )
                & ( Q @ N @ X2 @ Y ) ) )
       => ? [F2: nat > A] :
          ! [N5: nat] :
            ( ( P2 @ N5 @ ( F2 @ N5 ) )
            & ( Q @ N5 @ ( F2 @ N5 ) @ ( F2 @ ( suc @ N5 ) ) ) ) ) ) ).

% dependent_nat_choice
thf(fact_132_zero__reorient,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [X: A] :
          ( ( ( zero_zero @ A )
            = X )
          = ( X
            = ( zero_zero @ A ) ) ) ) ).

% zero_reorient
thf(fact_133_gr__zeroI,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N3: A] :
          ( ( N3
           != ( zero_zero @ A ) )
         => ( ord_less @ A @ ( zero_zero @ A ) @ N3 ) ) ) ).

% gr_zeroI
thf(fact_134_not__less__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N3: A] :
          ~ ( ord_less @ A @ N3 @ ( zero_zero @ A ) ) ) ).

% not_less_zero
thf(fact_135_gr__implies__not__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [M: A,N3: A] :
          ( ( ord_less @ A @ M @ N3 )
         => ( N3
           != ( zero_zero @ A ) ) ) ) ).

% gr_implies_not_zero
thf(fact_136_zero__less__iff__neq__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N3: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ N3 )
          = ( N3
           != ( zero_zero @ A ) ) ) ) ).

% zero_less_iff_neq_zero
thf(fact_137_n__lists__Nil,axiom,
    ! [A: $tType,N3: nat] :
      ( ( ( N3
          = ( zero_zero @ nat ) )
       => ( ( n_lists @ A @ N3 @ ( nil @ A ) )
          = ( cons @ ( list @ A ) @ ( nil @ A ) @ ( nil @ ( list @ A ) ) ) ) )
      & ( ( N3
         != ( zero_zero @ nat ) )
       => ( ( n_lists @ A @ N3 @ ( nil @ A ) )
          = ( nil @ ( list @ A ) ) ) ) ) ).

% n_lists_Nil
thf(fact_138_flpPseudoConsensus_OinfiniteExecutionCfg_Oelims,axiom,
    ! [P: $tType,V: $tType,S: $tType,Trans: P > S > ( messageValue @ V ) > S,Sends: P > S > ( messageValue @ V ) > ( message @ P @ V ) > nat,Start: P > S,X: configuration_ext @ P @ V @ S @ product_unit,Xa: ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ),Xb: ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( message @ P @ V ) ),Xc: nat,Y3: list @ ( configuration_ext @ P @ V @ S @ product_unit )] :
      ( ( fLPThe1922692578sensus @ P @ S @ V @ Trans @ Sends @ Start )
     => ( ( ( fLPThe137922386ionCfg @ P @ V @ S @ X @ Xa @ Xb @ Xc )
          = Y3 )
       => ( ( ( Xc
              = ( zero_zero @ nat ) )
           => ( Y3
             != ( cons @ ( configuration_ext @ P @ V @ S @ product_unit ) @ X @ ( nil @ ( configuration_ext @ P @ V @ S @ product_unit ) ) ) ) )
         => ~ ! [N: nat] :
                ( ( Xc
                  = ( suc @ N ) )
               => ( Y3
                 != ( Xa @ ( fLPThe137922386ionCfg @ P @ V @ S @ X @ Xa @ Xb @ N ) @ ( fLPThe221390223ionMsg @ P @ V @ S @ X @ Xa @ Xb @ N ) ) ) ) ) ) ) ).

% flpPseudoConsensus.infiniteExecutionCfg.elims
thf(fact_139_n__lists_Osimps_I1_J,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( n_lists @ A @ ( zero_zero @ nat ) @ Xs )
      = ( cons @ ( list @ A ) @ ( nil @ A ) @ ( nil @ ( list @ A ) ) ) ) ).

% n_lists.simps(1)
thf(fact_140_flpPseudoConsensus_OinfiniteExecutionMsg_Oelims,axiom,
    ! [P: $tType,V: $tType,S: $tType,Trans: P > S > ( messageValue @ V ) > S,Sends: P > S > ( messageValue @ V ) > ( message @ P @ V ) > nat,Start: P > S,X: configuration_ext @ P @ V @ S @ product_unit,Xa: ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ),Xb: ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( message @ P @ V ) ),Xc: nat,Y3: list @ ( message @ P @ V )] :
      ( ( fLPThe1922692578sensus @ P @ S @ V @ Trans @ Sends @ Start )
     => ( ( ( fLPThe221390223ionMsg @ P @ V @ S @ X @ Xa @ Xb @ Xc )
          = Y3 )
       => ( ( ( Xc
              = ( zero_zero @ nat ) )
           => ( Y3
             != ( nil @ ( message @ P @ V ) ) ) )
         => ~ ! [N: nat] :
                ( ( Xc
                  = ( suc @ N ) )
               => ( Y3
                 != ( Xb @ ( fLPThe137922386ionCfg @ P @ V @ S @ X @ Xa @ Xb @ N ) @ ( fLPThe221390223ionMsg @ P @ V @ S @ X @ Xa @ Xb @ N ) ) ) ) ) ) ) ).

% flpPseudoConsensus.infiniteExecutionMsg.elims
thf(fact_141_flpPseudoConsensus_OinfiniteExecutionCfg__infiniteExecutionMsg_Oinduct_I1_J,axiom,
    ! [P: $tType,V: $tType,S: $tType,Trans: P > S > ( messageValue @ V ) > S,Sends: P > S > ( messageValue @ V ) > ( message @ P @ V ) > nat,Start: P > S,P2: ( configuration_ext @ P @ V @ S @ product_unit ) > ( ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) ) > ( ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( message @ P @ V ) ) ) > nat > $o,Q: ( configuration_ext @ P @ V @ S @ product_unit ) > ( ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) ) > ( ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( message @ P @ V ) ) ) > nat > $o,A0: configuration_ext @ P @ V @ S @ product_unit,A1: ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ),A2: ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( message @ P @ V ) ),A3: nat] :
      ( ( fLPThe1922692578sensus @ P @ S @ V @ Trans @ Sends @ Start )
     => ( ! [Cfg: configuration_ext @ P @ V @ S @ product_unit,FStepCfg: ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ),FStepMsg: ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( message @ P @ V ) )] : ( P2 @ Cfg @ FStepCfg @ FStepMsg @ ( zero_zero @ nat ) )
       => ( ! [Cfg: configuration_ext @ P @ V @ S @ product_unit,FStepCfg: ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ),FStepMsg: ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( message @ P @ V ) ),N: nat] :
              ( ( P2 @ Cfg @ FStepCfg @ FStepMsg @ N )
             => ( ( Q @ Cfg @ FStepCfg @ FStepMsg @ N )
               => ( P2 @ Cfg @ FStepCfg @ FStepMsg @ ( suc @ N ) ) ) )
         => ( ! [Cfg: configuration_ext @ P @ V @ S @ product_unit,FStepCfg: ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ),FStepMsg: ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( message @ P @ V ) )] : ( Q @ Cfg @ FStepCfg @ FStepMsg @ ( zero_zero @ nat ) )
           => ( ! [Cfg: configuration_ext @ P @ V @ S @ product_unit,FStepCfg: ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ),FStepMsg: ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( message @ P @ V ) ),N: nat] :
                  ( ( P2 @ Cfg @ FStepCfg @ FStepMsg @ N )
                 => ( ( Q @ Cfg @ FStepCfg @ FStepMsg @ N )
                   => ( Q @ Cfg @ FStepCfg @ FStepMsg @ ( suc @ N ) ) ) )
             => ( P2 @ A0 @ A1 @ A2 @ A3 ) ) ) ) ) ) ).

% flpPseudoConsensus.infiniteExecutionCfg_infiniteExecutionMsg.induct(1)
thf(fact_142_flpPseudoConsensus_OinfiniteExecutionCfg__infiniteExecutionMsg_Oinduct_I2_J,axiom,
    ! [P: $tType,V: $tType,S: $tType,Trans: P > S > ( messageValue @ V ) > S,Sends: P > S > ( messageValue @ V ) > ( message @ P @ V ) > nat,Start: P > S,P2: ( configuration_ext @ P @ V @ S @ product_unit ) > ( ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) ) > ( ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( message @ P @ V ) ) ) > nat > $o,Q: ( configuration_ext @ P @ V @ S @ product_unit ) > ( ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) ) > ( ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( message @ P @ V ) ) ) > nat > $o,A4: configuration_ext @ P @ V @ S @ product_unit,A5: ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ),A6: ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( message @ P @ V ) ),A7: nat] :
      ( ( fLPThe1922692578sensus @ P @ S @ V @ Trans @ Sends @ Start )
     => ( ! [Cfg: configuration_ext @ P @ V @ S @ product_unit,FStepCfg: ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ),FStepMsg: ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( message @ P @ V ) )] : ( P2 @ Cfg @ FStepCfg @ FStepMsg @ ( zero_zero @ nat ) )
       => ( ! [Cfg: configuration_ext @ P @ V @ S @ product_unit,FStepCfg: ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ),FStepMsg: ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( message @ P @ V ) ),N: nat] :
              ( ( P2 @ Cfg @ FStepCfg @ FStepMsg @ N )
             => ( ( Q @ Cfg @ FStepCfg @ FStepMsg @ N )
               => ( P2 @ Cfg @ FStepCfg @ FStepMsg @ ( suc @ N ) ) ) )
         => ( ! [Cfg: configuration_ext @ P @ V @ S @ product_unit,FStepCfg: ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ),FStepMsg: ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( message @ P @ V ) )] : ( Q @ Cfg @ FStepCfg @ FStepMsg @ ( zero_zero @ nat ) )
           => ( ! [Cfg: configuration_ext @ P @ V @ S @ product_unit,FStepCfg: ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ),FStepMsg: ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( message @ P @ V ) ),N: nat] :
                  ( ( P2 @ Cfg @ FStepCfg @ FStepMsg @ N )
                 => ( ( Q @ Cfg @ FStepCfg @ FStepMsg @ N )
                   => ( Q @ Cfg @ FStepCfg @ FStepMsg @ ( suc @ N ) ) ) )
             => ( Q @ A4 @ A5 @ A6 @ A7 ) ) ) ) ) ) ).

% flpPseudoConsensus.infiniteExecutionCfg_infiniteExecutionMsg.induct(2)
thf(fact_143_flpPseudoConsensus_OinfiniteExecutionMsg_Osimps_I2_J,axiom,
    ! [P: $tType,V: $tType,S: $tType,Trans: P > S > ( messageValue @ V ) > S,Sends: P > S > ( messageValue @ V ) > ( message @ P @ V ) > nat,Start: P > S,Cfg2: configuration_ext @ P @ V @ S @ product_unit,FStepCfg2: ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ),FStepMsg2: ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( message @ P @ V ) ),N3: nat] :
      ( ( fLPThe1922692578sensus @ P @ S @ V @ Trans @ Sends @ Start )
     => ( ( fLPThe221390223ionMsg @ P @ V @ S @ Cfg2 @ FStepCfg2 @ FStepMsg2 @ ( suc @ N3 ) )
        = ( FStepMsg2 @ ( fLPThe137922386ionCfg @ P @ V @ S @ Cfg2 @ FStepCfg2 @ FStepMsg2 @ N3 ) @ ( fLPThe221390223ionMsg @ P @ V @ S @ Cfg2 @ FStepCfg2 @ FStepMsg2 @ N3 ) ) ) ) ).

% flpPseudoConsensus.infiniteExecutionMsg.simps(2)
thf(fact_144_flpPseudoConsensus_OinfiniteExecutionCfg_Osimps_I2_J,axiom,
    ! [P: $tType,V: $tType,S: $tType,Trans: P > S > ( messageValue @ V ) > S,Sends: P > S > ( messageValue @ V ) > ( message @ P @ V ) > nat,Start: P > S,Cfg2: configuration_ext @ P @ V @ S @ product_unit,FStepCfg2: ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ),FStepMsg2: ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( message @ P @ V ) ),N3: nat] :
      ( ( fLPThe1922692578sensus @ P @ S @ V @ Trans @ Sends @ Start )
     => ( ( fLPThe137922386ionCfg @ P @ V @ S @ Cfg2 @ FStepCfg2 @ FStepMsg2 @ ( suc @ N3 ) )
        = ( FStepCfg2 @ ( fLPThe137922386ionCfg @ P @ V @ S @ Cfg2 @ FStepCfg2 @ FStepMsg2 @ N3 ) @ ( fLPThe221390223ionMsg @ P @ V @ S @ Cfg2 @ FStepCfg2 @ FStepMsg2 @ N3 ) ) ) ) ).

% flpPseudoConsensus.infiniteExecutionCfg.simps(2)
thf(fact_145_flpPseudoConsensus_OinfiniteExecutionMsg_Osimps_I1_J,axiom,
    ! [S: $tType,V: $tType,P: $tType,Trans: P > S > ( messageValue @ V ) > S,Sends: P > S > ( messageValue @ V ) > ( message @ P @ V ) > nat,Start: P > S,Cfg2: configuration_ext @ P @ V @ S @ product_unit,FStepCfg2: ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ),FStepMsg2: ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( message @ P @ V ) )] :
      ( ( fLPThe1922692578sensus @ P @ S @ V @ Trans @ Sends @ Start )
     => ( ( fLPThe221390223ionMsg @ P @ V @ S @ Cfg2 @ FStepCfg2 @ FStepMsg2 @ ( zero_zero @ nat ) )
        = ( nil @ ( message @ P @ V ) ) ) ) ).

% flpPseudoConsensus.infiniteExecutionMsg.simps(1)
thf(fact_146_flpPseudoConsensus_OinfiniteExecutionCfg_Osimps_I1_J,axiom,
    ! [S: $tType,V: $tType,P: $tType,Trans: P > S > ( messageValue @ V ) > S,Sends: P > S > ( messageValue @ V ) > ( message @ P @ V ) > nat,Start: P > S,Cfg2: configuration_ext @ P @ V @ S @ product_unit,FStepCfg2: ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ),FStepMsg2: ( list @ ( configuration_ext @ P @ V @ S @ product_unit ) ) > ( list @ ( message @ P @ V ) ) > ( list @ ( message @ P @ V ) )] :
      ( ( fLPThe1922692578sensus @ P @ S @ V @ Trans @ Sends @ Start )
     => ( ( fLPThe137922386ionCfg @ P @ V @ S @ Cfg2 @ FStepCfg2 @ FStepMsg2 @ ( zero_zero @ nat ) )
        = ( cons @ ( configuration_ext @ P @ V @ S @ product_unit ) @ Cfg2 @ ( nil @ ( configuration_ext @ P @ V @ S @ product_unit ) ) ) ) ) ).

% flpPseudoConsensus.infiniteExecutionCfg.simps(1)
thf(fact_147_shift__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( bNF_Greatest_shift @ A @ B )
      = ( ^ [Lab: ( list @ A ) > B,K3: A,Kl: list @ A] : ( Lab @ ( cons @ A @ K3 @ Kl ) ) ) ) ).

% shift_def
thf(fact_148_less__numeral__extra_I3_J,axiom,
    ! [A: $tType] :
      ( ( linord1659791738miring @ A )
     => ~ ( ord_less @ A @ ( zero_zero @ A ) @ ( zero_zero @ A ) ) ) ).

% less_numeral_extra(3)
thf(fact_149_product__lists_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( product_lists @ A @ ( nil @ ( list @ A ) ) )
      = ( cons @ ( list @ A ) @ ( nil @ A ) @ ( nil @ ( list @ A ) ) ) ) ).

% product_lists.simps(1)
thf(fact_150_subseqs_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( subseqs @ A @ ( nil @ A ) )
      = ( cons @ ( list @ A ) @ ( nil @ A ) @ ( nil @ ( list @ A ) ) ) ) ).

% subseqs.simps(1)
thf(fact_151_length__code,axiom,
    ! [A: $tType] :
      ( ( size_size @ ( list @ A ) )
      = ( gen_length @ A @ ( zero_zero @ nat ) ) ) ).

% length_code
thf(fact_152_gen__length__code_I2_J,axiom,
    ! [B: $tType,N3: nat,X: B,Xs: list @ B] :
      ( ( gen_length @ B @ N3 @ ( cons @ B @ X @ Xs ) )
      = ( gen_length @ B @ ( suc @ N3 ) @ Xs ) ) ).

% gen_length_code(2)
thf(fact_153_gen__length__code_I1_J,axiom,
    ! [A: $tType,N3: nat] :
      ( ( gen_length @ A @ N3 @ ( nil @ A ) )
      = N3 ) ).

% gen_length_code(1)
thf(fact_154_insert__Nil,axiom,
    ! [A: $tType,X: A] :
      ( ( insert @ A @ X @ ( nil @ A ) )
      = ( cons @ A @ X @ ( nil @ A ) ) ) ).

% insert_Nil
thf(fact_155_nths__singleton,axiom,
    ! [A: $tType,A9: set @ nat,X: A] :
      ( ( ( member @ nat @ ( zero_zero @ nat ) @ A9 )
       => ( ( nths @ A @ ( cons @ A @ X @ ( nil @ A ) ) @ A9 )
          = ( cons @ A @ X @ ( nil @ A ) ) ) )
      & ( ~ ( member @ nat @ ( zero_zero @ nat ) @ A9 )
       => ( ( nths @ A @ ( cons @ A @ X @ ( nil @ A ) ) @ A9 )
          = ( nil @ A ) ) ) ) ).

% nths_singleton
thf(fact_156_of__nat__0__less__iff,axiom,
    ! [A: $tType] :
      ( ( linord1659791738miring @ A )
     => ! [N3: nat] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ ( semiring_1_of_nat @ A @ N3 ) )
          = ( ord_less @ nat @ ( zero_zero @ nat ) @ N3 ) ) ) ).

% of_nat_0_less_iff
thf(fact_157_of__nat__eq__iff,axiom,
    ! [A: $tType] :
      ( ( semiring_char_0 @ A )
     => ! [M: nat,N3: nat] :
          ( ( ( semiring_1_of_nat @ A @ M )
            = ( semiring_1_of_nat @ A @ N3 ) )
          = ( M = N3 ) ) ) ).

% of_nat_eq_iff
thf(fact_158_nths__nil,axiom,
    ! [A: $tType,A9: set @ nat] :
      ( ( nths @ A @ ( nil @ A ) @ A9 )
      = ( nil @ A ) ) ).

% nths_nil
thf(fact_159_of__nat__0,axiom,
    ! [A: $tType] :
      ( ( semiring_1 @ A )
     => ( ( semiring_1_of_nat @ A @ ( zero_zero @ nat ) )
        = ( zero_zero @ A ) ) ) ).

% of_nat_0
thf(fact_160_of__nat__0__eq__iff,axiom,
    ! [A: $tType] :
      ( ( semiring_char_0 @ A )
     => ! [N3: nat] :
          ( ( ( zero_zero @ A )
            = ( semiring_1_of_nat @ A @ N3 ) )
          = ( ( zero_zero @ nat )
            = N3 ) ) ) ).

% of_nat_0_eq_iff
thf(fact_161_of__nat__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( semiring_char_0 @ A )
     => ! [M: nat] :
          ( ( ( semiring_1_of_nat @ A @ M )
            = ( zero_zero @ A ) )
          = ( M
            = ( zero_zero @ nat ) ) ) ) ).

% of_nat_eq_0_iff
thf(fact_162_of__nat__less__iff,axiom,
    ! [A: $tType] :
      ( ( linord1659791738miring @ A )
     => ! [M: nat,N3: nat] :
          ( ( ord_less @ A @ ( semiring_1_of_nat @ A @ M ) @ ( semiring_1_of_nat @ A @ N3 ) )
          = ( ord_less @ nat @ M @ N3 ) ) ) ).

% of_nat_less_iff
thf(fact_163_of__nat__less__0__iff,axiom,
    ! [A: $tType] :
      ( ( linord1659791738miring @ A )
     => ! [M: nat] :
          ~ ( ord_less @ A @ ( semiring_1_of_nat @ A @ M ) @ ( zero_zero @ A ) ) ) ).

% of_nat_less_0_iff
thf(fact_164_of__nat__neq__0,axiom,
    ! [A: $tType] :
      ( ( semiring_char_0 @ A )
     => ! [N3: nat] :
          ( ( semiring_1_of_nat @ A @ ( suc @ N3 ) )
         != ( zero_zero @ A ) ) ) ).

% of_nat_neq_0
thf(fact_165_less__imp__of__nat__less,axiom,
    ! [A: $tType] :
      ( ( linord1659791738miring @ A )
     => ! [M: nat,N3: nat] :
          ( ( ord_less @ nat @ M @ N3 )
         => ( ord_less @ A @ ( semiring_1_of_nat @ A @ M ) @ ( semiring_1_of_nat @ A @ N3 ) ) ) ) ).

% less_imp_of_nat_less
thf(fact_166_of__nat__less__imp__less,axiom,
    ! [A: $tType] :
      ( ( linord1659791738miring @ A )
     => ! [M: nat,N3: nat] :
          ( ( ord_less @ A @ ( semiring_1_of_nat @ A @ M ) @ ( semiring_1_of_nat @ A @ N3 ) )
         => ( ord_less @ nat @ M @ N3 ) ) ) ).

% of_nat_less_imp_less
thf(fact_167_nths__all,axiom,
    ! [A: $tType,Xs: list @ A,I4: set @ nat] :
      ( ! [I2: nat] :
          ( ( ord_less @ nat @ I2 @ ( size_size @ ( list @ A ) @ Xs ) )
         => ( member @ nat @ I2 @ I4 ) )
     => ( ( nths @ A @ Xs @ I4 )
        = Xs ) ) ).

% nths_all
thf(fact_168_pos__int__cases,axiom,
    ! [K: int] :
      ( ( ord_less @ int @ ( zero_zero @ int ) @ K )
     => ~ ! [N: nat] :
            ( ( K
              = ( semiring_1_of_nat @ int @ N ) )
           => ~ ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) ) ) ).

% pos_int_cases
thf(fact_169_zero__less__imp__eq__int,axiom,
    ! [K: int] :
      ( ( ord_less @ int @ ( zero_zero @ int ) @ K )
     => ? [N: nat] :
          ( ( ord_less @ nat @ ( zero_zero @ nat ) @ N )
          & ( K
            = ( semiring_1_of_nat @ int @ N ) ) ) ) ).

% zero_less_imp_eq_int
thf(fact_170_list__ex1__simps_I1_J,axiom,
    ! [A: $tType,P2: A > $o] :
      ~ ( list_ex1 @ A @ P2 @ ( nil @ A ) ) ).

% list_ex1_simps(1)
thf(fact_171_nat__int__comparison_I2_J,axiom,
    ( ( ord_less @ nat )
    = ( ^ [A11: nat,B2: nat] : ( ord_less @ int @ ( semiring_1_of_nat @ int @ A11 ) @ ( semiring_1_of_nat @ int @ B2 ) ) ) ) ).

% nat_int_comparison(2)
thf(fact_172_int__ops_I1_J,axiom,
    ( ( semiring_1_of_nat @ int @ ( zero_zero @ nat ) )
    = ( zero_zero @ int ) ) ).

% int_ops(1)
thf(fact_173_neg__int__cases,axiom,
    ! [K: int] :
      ( ( ord_less @ int @ K @ ( zero_zero @ int ) )
     => ~ ! [N: nat] :
            ( ( K
              = ( uminus_uminus @ int @ ( semiring_1_of_nat @ int @ N ) ) )
           => ~ ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) ) ) ).

% neg_int_cases
thf(fact_174_neg__equal__iff__equal,axiom,
    ! [A: $tType] :
      ( ( group_add @ A )
     => ! [A8: A,B3: A] :
          ( ( ( uminus_uminus @ A @ A8 )
            = ( uminus_uminus @ A @ B3 ) )
          = ( A8 = B3 ) ) ) ).

% neg_equal_iff_equal
thf(fact_175_add_Oinverse__inverse,axiom,
    ! [A: $tType] :
      ( ( group_add @ A )
     => ! [A8: A] :
          ( ( uminus_uminus @ A @ ( uminus_uminus @ A @ A8 ) )
          = A8 ) ) ).

% add.inverse_inverse
thf(fact_176_add_Oinverse__neutral,axiom,
    ! [A: $tType] :
      ( ( group_add @ A )
     => ( ( uminus_uminus @ A @ ( zero_zero @ A ) )
        = ( zero_zero @ A ) ) ) ).

% add.inverse_neutral
thf(fact_177_neg__0__equal__iff__equal,axiom,
    ! [A: $tType] :
      ( ( group_add @ A )
     => ! [A8: A] :
          ( ( ( zero_zero @ A )
            = ( uminus_uminus @ A @ A8 ) )
          = ( ( zero_zero @ A )
            = A8 ) ) ) ).

% neg_0_equal_iff_equal
thf(fact_178_neg__equal__0__iff__equal,axiom,
    ! [A: $tType] :
      ( ( group_add @ A )
     => ! [A8: A] :
          ( ( ( uminus_uminus @ A @ A8 )
            = ( zero_zero @ A ) )
          = ( A8
            = ( zero_zero @ A ) ) ) ) ).

% neg_equal_0_iff_equal
thf(fact_179_equal__neg__zero,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A )
     => ! [A8: A] :
          ( ( A8
            = ( uminus_uminus @ A @ A8 ) )
          = ( A8
            = ( zero_zero @ A ) ) ) ) ).

% equal_neg_zero
thf(fact_180_neg__equal__zero,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A )
     => ! [A8: A] :
          ( ( ( uminus_uminus @ A @ A8 )
            = A8 )
          = ( A8
            = ( zero_zero @ A ) ) ) ) ).

% neg_equal_zero
thf(fact_181_neg__less__iff__less,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A )
     => ! [B3: A,A8: A] :
          ( ( ord_less @ A @ ( uminus_uminus @ A @ B3 ) @ ( uminus_uminus @ A @ A8 ) )
          = ( ord_less @ A @ A8 @ B3 ) ) ) ).

% neg_less_iff_less
thf(fact_182_less__neg__neg,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A )
     => ! [A8: A] :
          ( ( ord_less @ A @ A8 @ ( uminus_uminus @ A @ A8 ) )
          = ( ord_less @ A @ A8 @ ( zero_zero @ A ) ) ) ) ).

% less_neg_neg
thf(fact_183_neg__less__pos,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A )
     => ! [A8: A] :
          ( ( ord_less @ A @ ( uminus_uminus @ A @ A8 ) @ A8 )
          = ( ord_less @ A @ ( zero_zero @ A ) @ A8 ) ) ) ).

% neg_less_pos
thf(fact_184_neg__0__less__iff__less,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A )
     => ! [A8: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ ( uminus_uminus @ A @ A8 ) )
          = ( ord_less @ A @ A8 @ ( zero_zero @ A ) ) ) ) ).

% neg_0_less_iff_less
thf(fact_185_neg__less__0__iff__less,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A )
     => ! [A8: A] :
          ( ( ord_less @ A @ ( uminus_uminus @ A @ A8 ) @ ( zero_zero @ A ) )
          = ( ord_less @ A @ ( zero_zero @ A ) @ A8 ) ) ) ).

% neg_less_0_iff_less
thf(fact_186_negative__eq__positive,axiom,
    ! [N3: nat,M: nat] :
      ( ( ( uminus_uminus @ int @ ( semiring_1_of_nat @ int @ N3 ) )
        = ( semiring_1_of_nat @ int @ M ) )
      = ( ( N3
          = ( zero_zero @ nat ) )
        & ( M
          = ( zero_zero @ nat ) ) ) ) ).

% negative_eq_positive
thf(fact_187_negative__zless,axiom,
    ! [N3: nat,M: nat] : ( ord_less @ int @ ( uminus_uminus @ int @ ( semiring_1_of_nat @ int @ ( suc @ N3 ) ) ) @ ( semiring_1_of_nat @ int @ M ) ) ).

% negative_zless
thf(fact_188_minus__less__iff,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A )
     => ! [A8: A,B3: A] :
          ( ( ord_less @ A @ ( uminus_uminus @ A @ A8 ) @ B3 )
          = ( ord_less @ A @ ( uminus_uminus @ A @ B3 ) @ A8 ) ) ) ).

% minus_less_iff
thf(fact_189_less__minus__iff,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A )
     => ! [A8: A,B3: A] :
          ( ( ord_less @ A @ A8 @ ( uminus_uminus @ A @ B3 ) )
          = ( ord_less @ A @ B3 @ ( uminus_uminus @ A @ A8 ) ) ) ) ).

% less_minus_iff
thf(fact_190_verit__negate__coefficient_I2_J,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A )
     => ! [A8: A,B3: A] :
          ( ( ord_less @ A @ A8 @ B3 )
         => ( ord_less @ A @ ( uminus_uminus @ A @ B3 ) @ ( uminus_uminus @ A @ A8 ) ) ) ) ).

% verit_negate_coefficient(2)
thf(fact_191_minus__equation__iff,axiom,
    ! [A: $tType] :
      ( ( group_add @ A )
     => ! [A8: A,B3: A] :
          ( ( ( uminus_uminus @ A @ A8 )
            = B3 )
          = ( ( uminus_uminus @ A @ B3 )
            = A8 ) ) ) ).

% minus_equation_iff
thf(fact_192_equation__minus__iff,axiom,
    ! [A: $tType] :
      ( ( group_add @ A )
     => ! [A8: A,B3: A] :
          ( ( A8
            = ( uminus_uminus @ A @ B3 ) )
          = ( B3
            = ( uminus_uminus @ A @ A8 ) ) ) ) ).

% equation_minus_iff
thf(fact_193_int__cases,axiom,
    ! [Z2: int] :
      ( ! [N: nat] :
          ( Z2
         != ( semiring_1_of_nat @ int @ N ) )
     => ~ ! [N: nat] :
            ( Z2
           != ( uminus_uminus @ int @ ( semiring_1_of_nat @ int @ ( suc @ N ) ) ) ) ) ).

% int_cases
thf(fact_194_int__of__nat__induct,axiom,
    ! [P2: int > $o,Z2: int] :
      ( ! [N: nat] : ( P2 @ ( semiring_1_of_nat @ int @ N ) )
     => ( ! [N: nat] : ( P2 @ ( uminus_uminus @ int @ ( semiring_1_of_nat @ int @ ( suc @ N ) ) ) )
       => ( P2 @ Z2 ) ) ) ).

% int_of_nat_induct
thf(fact_195_int__cases4,axiom,
    ! [M: int] :
      ( ! [N: nat] :
          ( M
         != ( semiring_1_of_nat @ int @ N ) )
     => ~ ! [N: nat] :
            ( ( ord_less @ nat @ ( zero_zero @ nat ) @ N )
           => ( M
             != ( uminus_uminus @ int @ ( semiring_1_of_nat @ int @ N ) ) ) ) ) ).

% int_cases4
thf(fact_196_verit__comp__simplify1_I1_J,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [A8: A] :
          ~ ( ord_less @ A @ A8 @ A8 ) ) ).

% verit_comp_simplify1(1)
thf(fact_197_int__cases3,axiom,
    ! [K: int] :
      ( ( K
       != ( zero_zero @ int ) )
     => ( ! [N: nat] :
            ( ( K
              = ( semiring_1_of_nat @ int @ N ) )
           => ~ ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) )
       => ~ ! [N: nat] :
              ( ( K
                = ( uminus_uminus @ int @ ( semiring_1_of_nat @ int @ N ) ) )
             => ~ ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) ) ) ) ).

% int_cases3
thf(fact_198_negative__zless__0,axiom,
    ! [N3: nat] : ( ord_less @ int @ ( uminus_uminus @ int @ ( semiring_1_of_nat @ int @ ( suc @ N3 ) ) ) @ ( zero_zero @ int ) ) ).

% negative_zless_0
thf(fact_199_negD,axiom,
    ! [X: int] :
      ( ( ord_less @ int @ X @ ( zero_zero @ int ) )
     => ? [N: nat] :
          ( X
          = ( uminus_uminus @ int @ ( semiring_1_of_nat @ int @ ( suc @ N ) ) ) ) ) ).

% negD
thf(fact_200_compl__less__compl__iff,axiom,
    ! [A: $tType] :
      ( ( boolean_algebra @ A )
     => ! [X: A,Y3: A] :
          ( ( ord_less @ A @ ( uminus_uminus @ A @ X ) @ ( uminus_uminus @ A @ Y3 ) )
          = ( ord_less @ A @ Y3 @ X ) ) ) ).

% compl_less_compl_iff
thf(fact_201_compl__less__swap2,axiom,
    ! [A: $tType] :
      ( ( boolean_algebra @ A )
     => ! [Y3: A,X: A] :
          ( ( ord_less @ A @ ( uminus_uminus @ A @ Y3 ) @ X )
         => ( ord_less @ A @ ( uminus_uminus @ A @ X ) @ Y3 ) ) ) ).

% compl_less_swap2
thf(fact_202_compl__less__swap1,axiom,
    ! [A: $tType] :
      ( ( boolean_algebra @ A )
     => ! [Y3: A,X: A] :
          ( ( ord_less @ A @ Y3 @ ( uminus_uminus @ A @ X ) )
         => ( ord_less @ A @ X @ ( uminus_uminus @ A @ Y3 ) ) ) ) ).

% compl_less_swap1
thf(fact_203_zero__less__nat__eq,axiom,
    ! [Z2: int] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ ( nat2 @ Z2 ) )
      = ( ord_less @ int @ ( zero_zero @ int ) @ Z2 ) ) ).

% zero_less_nat_eq
thf(fact_204_of__int__0__less__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [Z2: int] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ ( ring_1_of_int @ A @ Z2 ) )
          = ( ord_less @ int @ ( zero_zero @ int ) @ Z2 ) ) ) ).

% of_int_0_less_iff
thf(fact_205_of__int__0,axiom,
    ! [A: $tType] :
      ( ( ring_1 @ A )
     => ( ( ring_1_of_int @ A @ ( zero_zero @ int ) )
        = ( zero_zero @ A ) ) ) ).

% of_int_0
thf(fact_206_of__int__0__eq__iff,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A )
     => ! [Z2: int] :
          ( ( ( zero_zero @ A )
            = ( ring_1_of_int @ A @ Z2 ) )
          = ( Z2
            = ( zero_zero @ int ) ) ) ) ).

% of_int_0_eq_iff
thf(fact_207_of__int__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A )
     => ! [Z2: int] :
          ( ( ( ring_1_of_int @ A @ Z2 )
            = ( zero_zero @ A ) )
          = ( Z2
            = ( zero_zero @ int ) ) ) ) ).

% of_int_eq_0_iff
thf(fact_208_of__int__less__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [W: int,Z2: int] :
          ( ( ord_less @ A @ ( ring_1_of_int @ A @ W ) @ ( ring_1_of_int @ A @ Z2 ) )
          = ( ord_less @ int @ W @ Z2 ) ) ) ).

% of_int_less_iff
thf(fact_209_zless__nat__conj,axiom,
    ! [W: int,Z2: int] :
      ( ( ord_less @ nat @ ( nat2 @ W ) @ ( nat2 @ Z2 ) )
      = ( ( ord_less @ int @ ( zero_zero @ int ) @ Z2 )
        & ( ord_less @ int @ W @ Z2 ) ) ) ).

% zless_nat_conj
thf(fact_210_nat__zminus__int,axiom,
    ! [N3: nat] :
      ( ( nat2 @ ( uminus_uminus @ int @ ( semiring_1_of_nat @ int @ N3 ) ) )
      = ( zero_zero @ nat ) ) ).

% nat_zminus_int
thf(fact_211_of__int__less__0__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [Z2: int] :
          ( ( ord_less @ A @ ( ring_1_of_int @ A @ Z2 ) @ ( zero_zero @ A ) )
          = ( ord_less @ int @ Z2 @ ( zero_zero @ int ) ) ) ) ).

% of_int_less_0_iff
thf(fact_212_nat__zero__as__int,axiom,
    ( ( zero_zero @ nat )
    = ( nat2 @ ( zero_zero @ int ) ) ) ).

% nat_zero_as_int
thf(fact_213_nat__mono__iff,axiom,
    ! [Z2: int,W: int] :
      ( ( ord_less @ int @ ( zero_zero @ int ) @ Z2 )
     => ( ( ord_less @ nat @ ( nat2 @ W ) @ ( nat2 @ Z2 ) )
        = ( ord_less @ int @ W @ Z2 ) ) ) ).

% nat_mono_iff
thf(fact_214_zless__nat__eq__int__zless,axiom,
    ! [M: nat,Z2: int] :
      ( ( ord_less @ nat @ M @ ( nat2 @ Z2 ) )
      = ( ord_less @ int @ ( semiring_1_of_nat @ int @ M ) @ Z2 ) ) ).

% zless_nat_eq_int_zless
thf(fact_215_of__int__pos,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [Z2: int] :
          ( ( ord_less @ int @ ( zero_zero @ int ) @ Z2 )
         => ( ord_less @ A @ ( zero_zero @ A ) @ ( ring_1_of_int @ A @ Z2 ) ) ) ) ).

% of_int_pos
thf(fact_216_of__nat__less__of__int__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [N3: nat,X: int] :
          ( ( ord_less @ A @ ( semiring_1_of_nat @ A @ N3 ) @ ( ring_1_of_int @ A @ X ) )
          = ( ord_less @ int @ ( semiring_1_of_nat @ int @ N3 ) @ X ) ) ) ).

% of_nat_less_of_int_iff
thf(fact_217_split__nat,axiom,
    ! [P2: nat > $o,I: int] :
      ( ( P2 @ ( nat2 @ I ) )
      = ( ! [N6: nat] :
            ( ( I
              = ( semiring_1_of_nat @ int @ N6 ) )
           => ( P2 @ N6 ) )
        & ( ( ord_less @ int @ I @ ( zero_zero @ int ) )
         => ( P2 @ ( zero_zero @ nat ) ) ) ) ) ).

% split_nat
thf(fact_218_one__less__nat__eq,axiom,
    ! [Z2: int] :
      ( ( ord_less @ nat @ ( suc @ ( zero_zero @ nat ) ) @ ( nat2 @ Z2 ) )
      = ( ord_less @ int @ ( one_one @ int ) @ Z2 ) ) ).

% one_less_nat_eq
thf(fact_219_nat__less__iff,axiom,
    ! [W: int,M: nat] :
      ( ( ord_less_eq @ int @ ( zero_zero @ int ) @ W )
     => ( ( ord_less @ nat @ ( nat2 @ W ) @ M )
        = ( ord_less @ int @ W @ ( semiring_1_of_nat @ int @ M ) ) ) ) ).

% nat_less_iff
thf(fact_220_le__zero__eq,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N3: A] :
          ( ( ord_less_eq @ A @ N3 @ ( zero_zero @ A ) )
          = ( N3
            = ( zero_zero @ A ) ) ) ) ).

% le_zero_eq
thf(fact_221_neg__le__iff__le,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A )
     => ! [B3: A,A8: A] :
          ( ( ord_less_eq @ A @ ( uminus_uminus @ A @ B3 ) @ ( uminus_uminus @ A @ A8 ) )
          = ( ord_less_eq @ A @ A8 @ B3 ) ) ) ).

% neg_le_iff_le
thf(fact_222_of__nat__le__iff,axiom,
    ! [A: $tType] :
      ( ( linord1659791738miring @ A )
     => ! [M: nat,N3: nat] :
          ( ( ord_less_eq @ A @ ( semiring_1_of_nat @ A @ M ) @ ( semiring_1_of_nat @ A @ N3 ) )
          = ( ord_less_eq @ nat @ M @ N3 ) ) ) ).

% of_nat_le_iff
thf(fact_223_of__nat__1,axiom,
    ! [A: $tType] :
      ( ( semiring_1 @ A )
     => ( ( semiring_1_of_nat @ A @ ( one_one @ nat ) )
        = ( one_one @ A ) ) ) ).

% of_nat_1
thf(fact_224_of__nat__1__eq__iff,axiom,
    ! [A: $tType] :
      ( ( semiring_char_0 @ A )
     => ! [N3: nat] :
          ( ( ( one_one @ A )
            = ( semiring_1_of_nat @ A @ N3 ) )
          = ( N3
            = ( one_one @ nat ) ) ) ) ).

% of_nat_1_eq_iff
thf(fact_225_of__nat__eq__1__iff,axiom,
    ! [A: $tType] :
      ( ( semiring_char_0 @ A )
     => ! [N3: nat] :
          ( ( ( semiring_1_of_nat @ A @ N3 )
            = ( one_one @ A ) )
          = ( N3
            = ( one_one @ nat ) ) ) ) ).

% of_nat_eq_1_iff
thf(fact_226_neg__0__le__iff__le,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A )
     => ! [A8: A] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( uminus_uminus @ A @ A8 ) )
          = ( ord_less_eq @ A @ A8 @ ( zero_zero @ A ) ) ) ) ).

% neg_0_le_iff_le
thf(fact_227_neg__le__0__iff__le,axiom,
    ! [A: $tType] :
      ( ( ordered_ab_group_add @ A )
     => ! [A8: A] :
          ( ( ord_less_eq @ A @ ( uminus_uminus @ A @ A8 ) @ ( zero_zero @ A ) )
          = ( ord_less_eq @ A @ ( zero_zero @ A ) @ A8 ) ) ) ).

% neg_le_0_iff_le
thf(fact_228_less__eq__neg__nonpos,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A )
     => ! [A8: A] :
          ( ( ord_less_eq @ A @ A8 @ ( uminus_uminus @ A @ A8 ) )
          = ( ord_less_eq @ A @ A8 @ ( zero_zero @ A ) ) ) ) ).

% less_eq_neg_nonpos
thf(fact_229_neg__less__eq__nonneg,axiom,
    ! [A: $tType] :
      ( ( linord219039673up_add @ A )
     => ! [A8: A] :
          ( ( ord_less_eq @ A @ ( uminus_uminus @ A @ A8 ) @ A8 )
          = ( ord_less_eq @ A @ ( zero_zero @ A ) @ A8 ) ) ) ).

% neg_less_eq_nonneg
thf(fact_230_of__nat__le__0__iff,axiom,
    ! [A: $tType] :
      ( ( linord1659791738miring @ A )
     => ! [M: nat] :
          ( ( ord_less_eq @ A @ ( semiring_1_of_nat @ A @ M ) @ ( zero_zero @ A ) )
          = ( M
            = ( zero_zero @ nat ) ) ) ) ).

% of_nat_le_0_iff
thf(fact_231_nat__1,axiom,
    ( ( nat2 @ ( one_one @ int ) )
    = ( suc @ ( zero_zero @ nat ) ) ) ).

% nat_1
thf(fact_232_nat__le__0,axiom,
    ! [Z2: int] :
      ( ( ord_less_eq @ int @ Z2 @ ( zero_zero @ int ) )
     => ( ( nat2 @ Z2 )
        = ( zero_zero @ nat ) ) ) ).

% nat_le_0
thf(fact_233_nat__0__iff,axiom,
    ! [I: int] :
      ( ( ( nat2 @ I )
        = ( zero_zero @ nat ) )
      = ( ord_less_eq @ int @ I @ ( zero_zero @ int ) ) ) ).

% nat_0_iff
thf(fact_234_of__int__le__0__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [Z2: int] :
          ( ( ord_less_eq @ A @ ( ring_1_of_int @ A @ Z2 ) @ ( zero_zero @ A ) )
          = ( ord_less_eq @ int @ Z2 @ ( zero_zero @ int ) ) ) ) ).

% of_int_le_0_iff
thf(fact_235_of__int__0__le__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [Z2: int] :
          ( ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( ring_1_of_int @ A @ Z2 ) )
          = ( ord_less_eq @ int @ ( zero_zero @ int ) @ Z2 ) ) ) ).

% of_int_0_le_iff
thf(fact_236_of__int__less__1__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [Z2: int] :
          ( ( ord_less @ A @ ( ring_1_of_int @ A @ Z2 ) @ ( one_one @ A ) )
          = ( ord_less @ int @ Z2 @ ( one_one @ int ) ) ) ) ).

% of_int_less_1_iff
thf(fact_237_of__int__1__less__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [Z2: int] :
          ( ( ord_less @ A @ ( one_one @ A ) @ ( ring_1_of_int @ A @ Z2 ) )
          = ( ord_less @ int @ ( one_one @ int ) @ Z2 ) ) ) ).

% of_int_1_less_iff
thf(fact_238_of__int__nonneg,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [Z2: int] :
          ( ( ord_less_eq @ int @ ( zero_zero @ int ) @ Z2 )
         => ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( ring_1_of_int @ A @ Z2 ) ) ) ) ).

% of_int_nonneg
thf(fact_239_verit__comp__simplify1_I3_J,axiom,
    ! [B: $tType] :
      ( ( linorder @ B )
     => ! [B4: B,A13: B] :
          ( ( ~ ( ord_less_eq @ B @ B4 @ A13 ) )
          = ( ord_less @ B @ A13 @ B4 ) ) ) ).

% verit_comp_simplify1(3)
thf(fact_240_le__numeral__extra_I4_J,axiom,
    ! [A: $tType] :
      ( ( linord1659791738miring @ A )
     => ( ord_less_eq @ A @ ( one_one @ A ) @ ( one_one @ A ) ) ) ).

% le_numeral_extra(4)
thf(fact_241_one__reorient,axiom,
    ! [A: $tType] :
      ( ( one @ A )
     => ! [X: A] :
          ( ( ( one_one @ A )
            = X )
          = ( X
            = ( one_one @ A ) ) ) ) ).

% one_reorient
thf(fact_242_lift__Suc__antimono__le,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [F: nat > A,N3: nat,N4: nat] :
          ( ! [N: nat] : ( ord_less_eq @ A @ ( F @ ( suc @ N ) ) @ ( F @ N ) )
         => ( ( ord_less_eq @ nat @ N3 @ N4 )
           => ( ord_less_eq @ A @ ( F @ N4 ) @ ( F @ N3 ) ) ) ) ) ).

% lift_Suc_antimono_le
thf(fact_243_lift__Suc__mono__le,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [F: nat > A,N3: nat,N4: nat] :
          ( ! [N: nat] : ( ord_less_eq @ A @ ( F @ N ) @ ( F @ ( suc @ N ) ) )
         => ( ( ord_less_eq @ nat @ N3 @ N4 )
           => ( ord_less_eq @ A @ ( F @ N3 ) @ ( F @ N4 ) ) ) ) ) ).

% lift_Suc_mono_le
thf(fact_244_zero__le,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [X: A] : ( ord_less_eq @ A @ ( zero_zero @ A ) @ X ) ) ).

% zero_le
thf(fact_245_le__numeral__extra_I3_J,axiom,
    ! [A: $tType] :
      ( ( linord1659791738miring @ A )
     => ( ord_less_eq @ A @ ( zero_zero @ A ) @ ( zero_zero @ A ) ) ) ).

% le_numeral_extra(3)
thf(fact_246_less__numeral__extra_I4_J,axiom,
    ! [A: $tType] :
      ( ( linord1659791738miring @ A )
     => ~ ( ord_less @ A @ ( one_one @ A ) @ ( one_one @ A ) ) ) ).

% less_numeral_extra(4)
thf(fact_247_of__nat__mono,axiom,
    ! [A: $tType] :
      ( ( linord1659791738miring @ A )
     => ! [I: nat,J: nat] :
          ( ( ord_less_eq @ nat @ I @ J )
         => ( ord_less_eq @ A @ ( semiring_1_of_nat @ A @ I ) @ ( semiring_1_of_nat @ A @ J ) ) ) ) ).

% of_nat_mono
thf(fact_248_less__minus__one__simps_I4_J,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ~ ( ord_less @ A @ ( one_one @ A ) @ ( uminus_uminus @ A @ ( one_one @ A ) ) ) ) ).

% less_minus_one_simps(4)
thf(fact_249_less__minus__one__simps_I2_J,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ( ord_less @ A @ ( uminus_uminus @ A @ ( one_one @ A ) ) @ ( one_one @ A ) ) ) ).

% less_minus_one_simps(2)
thf(fact_250_zero__neq__neg__one,axiom,
    ! [A: $tType] :
      ( ( ring_char_0 @ A )
     => ( ( zero_zero @ A )
       != ( uminus_uminus @ A @ ( one_one @ A ) ) ) ) ).

% zero_neq_neg_one

% Type constructors (42)
thf(tcon_fun___Lattices_Oboolean__algebra,axiom,
    ! [A14: $tType,A15: $tType] :
      ( ( boolean_algebra @ A15 )
     => ( boolean_algebra @ ( A14 > A15 ) ) ) ).

thf(tcon_fun___Orderings_Oorder,axiom,
    ! [A14: $tType,A15: $tType] :
      ( ( order @ A15 )
     => ( order @ ( A14 > A15 ) ) ) ).

thf(tcon_fun___Orderings_Oord,axiom,
    ! [A14: $tType,A15: $tType] :
      ( ( ord @ A15 )
     => ( ord @ ( A14 > A15 ) ) ) ).

thf(tcon_Int_Oint___Rings_Olinordered__nonzero__semiring,axiom,
    linord1659791738miring @ int ).

thf(tcon_Int_Oint___Groups_Olinordered__ab__group__add,axiom,
    linord219039673up_add @ int ).

thf(tcon_Int_Oint___Groups_Oordered__ab__group__add,axiom,
    ordered_ab_group_add @ int ).

thf(tcon_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom @ int ).

thf(tcon_Int_Oint___Nat_Osemiring__char__0,axiom,
    semiring_char_0 @ int ).

thf(tcon_Int_Oint___Orderings_Olinorder,axiom,
    linorder @ int ).

thf(tcon_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1 @ int ).

thf(tcon_Int_Oint___Groups_Ogroup__add,axiom,
    group_add @ int ).

thf(tcon_Int_Oint___Orderings_Oorder_1,axiom,
    order @ int ).

thf(tcon_Int_Oint___Nat_Oring__char__0,axiom,
    ring_char_0 @ int ).

thf(tcon_Int_Oint___Orderings_Oord_2,axiom,
    ord @ int ).

thf(tcon_Int_Oint___Rings_Oring__1,axiom,
    ring_1 @ int ).

thf(tcon_Int_Oint___Groups_Ozero,axiom,
    zero @ int ).

thf(tcon_Int_Oint___Groups_Oone,axiom,
    one @ int ).

thf(tcon_Nat_Onat___Groups_Ocanonically__ordered__monoid__add,axiom,
    canoni770627133id_add @ nat ).

thf(tcon_Nat_Onat___Rings_Olinordered__nonzero__semiring_3,axiom,
    linord1659791738miring @ nat ).

thf(tcon_Nat_Onat___Orderings_Owellorder,axiom,
    wellorder @ nat ).

thf(tcon_Nat_Onat___Nat_Osemiring__char__0_4,axiom,
    semiring_char_0 @ nat ).

thf(tcon_Nat_Onat___Orderings_Olinorder_5,axiom,
    linorder @ nat ).

thf(tcon_Nat_Onat___Rings_Osemiring__1_6,axiom,
    semiring_1 @ nat ).

thf(tcon_Nat_Onat___Orderings_Oorder_7,axiom,
    order @ nat ).

thf(tcon_Nat_Onat___Orderings_Oord_8,axiom,
    ord @ nat ).

thf(tcon_Nat_Onat___Groups_Ozero_9,axiom,
    zero @ nat ).

thf(tcon_Nat_Onat___Groups_Oone_10,axiom,
    one @ nat ).

thf(tcon_Nat_Onat___Nat_Osize,axiom,
    size @ nat ).

thf(tcon_Set_Oset___Lattices_Oboolean__algebra_11,axiom,
    ! [A14: $tType] : ( boolean_algebra @ ( set @ A14 ) ) ).

thf(tcon_Set_Oset___Orderings_Oorder_12,axiom,
    ! [A14: $tType] : ( order @ ( set @ A14 ) ) ).

thf(tcon_Set_Oset___Orderings_Oord_13,axiom,
    ! [A14: $tType] : ( ord @ ( set @ A14 ) ) ).

thf(tcon_HOL_Obool___Lattices_Oboolean__algebra_14,axiom,
    boolean_algebra @ $o ).

thf(tcon_HOL_Obool___Orderings_Olinorder_15,axiom,
    linorder @ $o ).

thf(tcon_HOL_Obool___Orderings_Oorder_16,axiom,
    order @ $o ).

thf(tcon_HOL_Obool___Orderings_Oord_17,axiom,
    ord @ $o ).

thf(tcon_List_Olist___Nat_Osize_18,axiom,
    ! [A14: $tType] : ( size @ ( list @ A14 ) ) ).

thf(tcon_Product__Type_Ounit___Lattices_Oboolean__algebra_19,axiom,
    boolean_algebra @ product_unit ).

thf(tcon_Product__Type_Ounit___Orderings_Owellorder_20,axiom,
    wellorder @ product_unit ).

thf(tcon_Product__Type_Ounit___Orderings_Olinorder_21,axiom,
    linorder @ product_unit ).

thf(tcon_Product__Type_Ounit___Orderings_Oorder_22,axiom,
    order @ product_unit ).

thf(tcon_Product__Type_Ounit___Orderings_Oord_23,axiom,
    ord @ product_unit ).

thf(tcon_AsynchronousSystem_Omessage___Nat_Osize_24,axiom,
    ! [A14: $tType,A15: $tType] : ( size @ ( message @ A14 @ A15 ) ) ).

% Conjectures (1)
thf(conj_0,conjecture,
    prefixList @ ( configuration_ext @ p @ v @ s @ product_unit ) @ ( fe @ m ) @ ( fe @ na ) ).

%------------------------------------------------------------------------------
